/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.assistant.command;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.req.sysml.assistant.command.SatisfyCreateCommand;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class AddSatisfyLinkCommand
extends RecordingCommand {
    protected Element selectedElement;
    TransactionalEditingDomain domain;

    public AddSatisfyLinkCommand(TransactionalEditingDomain domain, Element selectedElement) {
        super(domain, "Add Satisfy Link Command");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    private Package getToPackage(Element elem) {
        Package tmp = elem.getNearestPackage();
        while (tmp.getOwner() != null && tmp.getOwner() instanceof Package) {
            tmp = (Package)tmp.getOwner();
        }
        return tmp;
    }

    protected void doExecute() {
        UMLContentProvider provider = new UMLContentProvider((EObject)this.getToPackage(this.selectedElement), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
        ReferenceSelector selector = new ReferenceSelector();
        selector.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        selector.setContentProvider((IStaticContentProvider)provider);
        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, "Choose the model elements that satisfy the requirement");
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        dialog.create();
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int i = 0;
            while (i < result.length) {
                Element currentElement = (Element)result[i];
                SatisfyCreateCommand satisfyCreateCommand = new SatisfyCreateCommand(this.domain, (NamedElement)currentElement, (NamedElement)this.selectedElement);
                satisfyCreateCommand.execute();
                ++i;
            }
        }
    }
}

