/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.assistant.command;

import java.text.DecimalFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.req.sysml.assistant.command.DecomposeReqCommand;
import org.eclipse.papyrus.req.sysml.preferences.Activator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class InitDecomposeReqCommand
extends RecordingCommand {
    protected Element selectedElement;
    TransactionalEditingDomain domain;

    public InitDecomposeReqCommand(TransactionalEditingDomain domain, Element selectedElement) {
        super(domain, "DecomposeReqCommand");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    protected void doExecute() {
        String concatenedString = "";
        Package owner = null;
        if (this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement") != null) {
            Stereotype stereotype = this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement");
            concatenedString = String.valueOf(concatenedString) + "\n" + this.selectedElement.getValue(stereotype, "text");
            owner = this.selectedElement.getNearestPackage();
            String id = InitDecomposeReqCommand.getNewIDReq((Class)this.selectedElement, stereotype);
            Class req = owner.createOwnedClass(id, false);
            Stereotype reqStereotype = req.getApplicableStereotype("SysML::Requirements::Requirement");
            req.applyStereotype(reqStereotype);
            req.setValue(reqStereotype, "text", (Object)concatenedString);
            req.setValue(reqStereotype, "id", (Object)id);
            DecomposeReqCommand decompositionReqCreateCommand = new DecomposeReqCommand(this.domain, req, (Class)this.selectedElement);
            decompositionReqCreateCommand.execute();
        }
    }

    public static String getNewIDReq(Class parent, Stereotype stereotype) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String prefix = store.getString("REQUIREMENT_ID_PREFIX");
        String separator = store.getString("CHILD_REQUIREMENTS_SEPARATOR");
        String parentRequirementId = (String)parent.getValue(stereotype, "id");
        String parentRequirementIdSuffix = parentRequirementId.replaceAll(prefix, "");
        int digit = store.getInt("REQUIREMENT_ID_DIGIT");
        int i = 0;
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(digit);
        String value = df.format(i);
        boolean IDexist = true;
        while (IDexist) {
            IDexist = false;
            value = df.format(++i);
            EList classifiers = parent.getNestedClassifiers();
            Iterator iterator = classifiers.iterator();
            while (iterator.hasNext() && !IDexist) {
                Classifier classifier = (Classifier)iterator.next();
                Stereotype reqStereotype = classifier.getAppliedStereotype("SysML::Requirements::Requirement");
                if (reqStereotype == null || classifier.getValue(reqStereotype, "id") == null) continue;
                String existedID = (String)classifier.getValue(reqStereotype, "id");
                String newID = String.valueOf(prefix) + parentRequirementIdSuffix + separator + value;
                if (!newID.equals(existedID)) continue;
                IDexist = true;
            }
        }
        return String.valueOf(prefix) + parentRequirementIdSuffix + separator + value;
    }
}

