/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis.ITracabilityRule;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.command.SatisfactionCreateCommand;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;

public class SatisfyRule
implements ITracabilityRule {
    @Override
    public boolean canApplyTracability(Element element) {
        if (element instanceof UseCase && element.getAppliedStereotype("SysML::Requirements::Requirement") == null) {
            UseCase currentClass = (UseCase)element;
            boolean containsAnAbstraction = false;
            for (Dependency dependency : currentClass.getClientDependencies()) {
                if (!(dependency instanceof Abstraction)) continue;
                if (dependency.getAppliedStereotype("SysML::Requirements::Satisfy") != null) {
                    containsAnAbstraction = true;
                }
                if (!(dependency instanceof Abstraction)) continue;
                containsAnAbstraction = true;
            }
            return !containsAnAbstraction;
        }
        return false;
    }

    @Override
    public boolean applyTracability(Element element, TransactionalEditingDomain domain) {
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        dialog.setContentProvider((ITreeContentProvider)new UMLContentProvider((EObject)element.getNearestPackage(), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement()));
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        dialog.setMessage("Choose Satisfy Link for " + ((NamedElement)element).getQualifiedName());
        dialog.setTitle("Choose Satisfy Link for " + ((NamedElement)element).getName());
        dialog.create();
        dialog.setDescription("Choose Satisfy Link for " + ((NamedElement)element).getQualifiedName());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            SatisfactionCreateCommand cmd = new SatisfactionCreateCommand(domain, (NamedElement)result[0], (NamedElement)element);
            domain.getCommandStack().execute((Command)cmd);
        }
        return false;
    }
}

