/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.command;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateToDoReviewCommand
extends RecordingCommand {
    protected Actor theauthor = null;
    protected Element container = null;
    protected String subject;
    protected EObject diff;

    public CreateToDoReviewCommand(TransactionalEditingDomain domain, Actor currentAuthor, Element container, String subject, EObject diff) {
        super(domain, "create Review");
        this.theauthor = currentAuthor;
        this.container = container;
        this.subject = subject;
        this.diff = diff;
    }

    protected void doExecute() {
        Comment cmt = UMLFactory.eINSTANCE.createComment();
        cmt.setBody("Your review");
        this.container.getOwnedComments().add((Object)cmt);
        Stereotype review = cmt.getApplicableStereotype("ReviewProfile::Todo");
        cmt.applyStereotype(review);
        cmt.setValue(review, "subject", (Object)this.subject);
        cmt.setBody(String.valueOf(this.theauthor.getName()) + " has done " + this.subject);
        Stereotype authorStereotype = this.theauthor.getApplicableStereotype("PapyrusVersioningExtensions::Author");
        cmt.setValue(review, "author", (Object)this.theauthor.getStereotypeApplication(authorStereotype));
        Date today = new Date();
        DateFormat shortDateFormat = DateFormat.getDateTimeInstance(3, 3);
        cmt.setValue(review, "date", (Object)shortDateFormat.format(today));
        Resource resource = this.diff.eResource();
        if (resource != null) {
            String uriFragment = resource.getURIFragment(this.diff);
            cmt.setValue(review, "diffRef", (Object)resource.getURIFragment(this.diff));
        }
    }
}

