/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.core;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.revision.tool.command.CreateDifferenceCommand;
import org.eclipse.papyrus.revision.tool.command.CreateMatchCommand;
import org.eclipse.papyrus.revision.tool.command.CreateToDoReviewCommand;
import org.eclipse.papyrus.revision.tool.core.ReviewResourceManager;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class AddingDiffListener
implements ResourceSetListener {
    protected ReviewResourceManager reviewResourceManager;

    public AddingDiffListener(ReviewResourceManager reviewResourceManager) {
        this.reviewResourceManager = reviewResourceManager;
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CreateToDoReviewCommand createToDoReviewCommand;
        RecordingCommand createDifferenceCommand;
        ReferenceChange difference;
        EObject notifier;
        ArrayList<RecordingCommand> commands = new ArrayList<RecordingCommand>();
        boolean noADD = true;
        for (Notification notif : event.getNotifications()) {
            CreateToDoReviewCommand createToDoReviewCommand2;
            CreateMatchCommand createDifferenceCommand2;
            ReferenceChange difference2;
            Match match;
            if (notif.getEventType() == 3 && notif.getNotifier() instanceof EObject) {
                notifier = (EObject)notif.getNotifier();
                if (this.reviewResourceManager.getWorkingModel().eResource().equals(notifier.eResource())) {
                    String subjectToWrite = notif.getNewValue().getClass().getSimpleName();
                    if (notif.getNewValue() instanceof NamedElement && ((NamedElement)notif.getNewValue()).getName() != null) {
                        subjectToWrite = ((NamedElement)notif.getNewValue()).getName();
                    }
                    if (((EReference)notif.getFeature()).isContainment()) {
                        noADD = false;
                        difference = CompareFactory.eINSTANCE.createReferenceChange();
                        difference.setSource(DifferenceSource.LEFT);
                        difference.setKind(DifferenceKind.ADD);
                        difference.setReference((EReference)notif.getFeature());
                        difference.setValue((EObject)notif.getNewValue());
                        createDifferenceCommand = new CreateDifferenceCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getDiffModel().getMatch((EObject)this.reviewResourceManager.getWorkingModel()), (Diff)difference);
                        commands.add(createDifferenceCommand);
                        createToDoReviewCommand = new CreateToDoReviewCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getCurrentAuthor(), (Element)this.reviewResourceManager.getCurrentReviewModel(), "Add " + subjectToWrite, (EObject)difference);
                        commands.add(createToDoReviewCommand);
                    } else {
                        match = CompareFactory.eINSTANCE.createMatch();
                        match.setLeft((EObject)notif.getNotifier());
                        difference2 = CompareFactory.eINSTANCE.createReferenceChange();
                        difference2.setSource(DifferenceSource.LEFT);
                        difference2.setKind(DifferenceKind.ADD);
                        difference2.setReference((EReference)notif.getFeature());
                        difference2.setValue((EObject)notif.getNewValue());
                        match.getDifferences().add((Object)difference2);
                        createDifferenceCommand2 = new CreateMatchCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getDiffModel().getMatch((EObject)this.reviewResourceManager.getWorkingModel()), match);
                        commands.add(createDifferenceCommand2);
                        createToDoReviewCommand2 = new CreateToDoReviewCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getCurrentAuthor(), (Element)this.reviewResourceManager.getCurrentReviewModel(), "Set " + ((EReference)notif.getFeature()).getName() + " " + subjectToWrite, (EObject)match);
                        commands.add(createToDoReviewCommand2);
                    }
                }
            }
            if (notif.getEventType() != 4 || !(notif.getNotifier() instanceof EObject)) continue;
            String subjectToWrite = notif.getOldValue().getClass().getSimpleName();
            if (notif.getNewValue() instanceof NamedElement && ((NamedElement)notif.getOldValue()).getName() != null) {
                subjectToWrite = ((NamedElement)notif.getOldValue()).getName();
            }
            EObject notifier2 = (EObject)notif.getNotifier();
            if (!this.reviewResourceManager.getWorkingModel().eResource().equals(notifier2.eResource())) continue;
            match = CompareFactory.eINSTANCE.createMatch();
            match.setLeft((EObject)notif.getNotifier());
            difference2 = CompareFactory.eINSTANCE.createReferenceChange();
            difference2.setSource(DifferenceSource.LEFT);
            difference2.setKind(DifferenceKind.DELETE);
            difference2.setReference((EReference)notif.getFeature());
            difference2.setValue((EObject)notif.getOldValue());
            match.getDifferences().add((Object)difference2);
            createDifferenceCommand2 = new CreateMatchCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getDiffModel().getMatch((EObject)this.reviewResourceManager.getWorkingModel()), match);
            commands.add(createDifferenceCommand2);
            createToDoReviewCommand2 = new CreateToDoReviewCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getCurrentAuthor(), (Element)this.reviewResourceManager.getCurrentReviewModel(), "Remove " + ((EReference)notif.getFeature()).getName() + " " + subjectToWrite, (EObject)match);
            commands.add(createToDoReviewCommand2);
        }
        if (noADD) {
            for (Notification notif : event.getNotifications()) {
                if (notif.getEventType() != 1 || !(notif.getNotifier() instanceof EObject)) continue;
                notifier = (EObject)notif.getNotifier();
                if (!this.reviewResourceManager.getWorkingModel().eResource().equals(notifier.eResource())) continue;
                noADD = false;
                if (!(notif.getFeature() instanceof EAttribute)) continue;
                Match match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft((EObject)notif.getNotifier());
                difference = CompareFactory.eINSTANCE.createAttributeChange();
                difference.setSource(DifferenceSource.LEFT);
                difference.setKind(DifferenceKind.CHANGE);
                difference.setAttribute((EAttribute)notif.getFeature());
                difference.setValue(notif.getOldValue());
                match.getDifferences().add((Object)difference);
                createDifferenceCommand = new CreateMatchCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getDiffModel().getMatch((EObject)this.reviewResourceManager.getWorkingModel()), match);
                commands.add(createDifferenceCommand);
                createToDoReviewCommand = new CreateToDoReviewCommand(this.reviewResourceManager.getDomain(), this.reviewResourceManager.getCurrentAuthor(), (Element)this.reviewResourceManager.getCurrentReviewModel(), "Set " + ((EAttribute)notif.getFeature()).getName() + " " + notif.getNewValue(), (EObject)match);
                commands.add(createToDoReviewCommand);
            }
        }
        return commands.isEmpty() ? null : new CompoundCommand(commands);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }
}

