/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.core;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.revision.tool.Activator;
import org.eclipse.papyrus.revision.tool.core.AddingDiffListener;
import org.eclipse.papyrus.revision.tool.core.RefreshFigureListener;
import org.eclipse.papyrus.revision.tool.dialogs.CreateAuthorDialog;
import org.eclipse.papyrus.revision.tool.dialogs.CreateOrSelectReviewModelDialog;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

public class ReviewResourceManager {
    protected Model UMLWorkingModel;
    protected ModelSet modelSet;
    protected Model reviewModel;
    protected Actor currentAuthor;
    protected AddingDiffListener addingDiffListener = new AddingDiffListener(this);
    protected RefreshFigureListener refreshFigureListener = new RefreshFigureListener(this);
    protected Comparison diffModel = null;
    protected boolean modeRevisionRunning = false;

    public void dispose() {
        if (this.addingDiffListener != null) {
            this.getDomain().removeResourceSetListener((ResourceSetListener)this.addingDiffListener);
        }
        if (this.refreshFigureListener != null) {
            this.getDomain().removeResourceSetListener((ResourceSetListener)this.refreshFigureListener);
        }
        this.modeRevisionRunning = false;
        this.refreshFigureListener = null;
        this.diffModel = null;
        this.reviewModel = null;
        this.currentAuthor = null;
        this.UMLWorkingModel = null;
        this.modelSet = null;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part = null;
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                part = activePage.getActiveEditor();
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        if (this.isImportant((IWorkbenchPart)part)) {
            return part;
        }
        return null;
    }

    public Model getCurrentReviewModelWithoutLoading() {
        return this.reviewModel;
    }

    public Model getCurrentReviewModel() {
        if (this.reviewModel == null) {
            CreateOrSelectReviewModelDialog dialog = new CreateOrSelectReviewModelDialog(new Shell(), this);
            dialog.open();
            this.getDomain().addResourceSetListener((ResourceSetListener)this.refreshFigureListener);
        }
        return this.reviewModel;
    }

    public Comparison getDiffModel() {
        if (this.diffModel == null) {
            this.getCurrentReviewModel();
            Resource reviewResource = this.getCurrentReviewModel().eResource();
            for (EObject currentRoot : reviewResource.getContents()) {
                if (!(currentRoot instanceof Comparison)) continue;
                this.diffModel = (Comparison)currentRoot;
            }
            if (this.diffModel == null) {
                this.diffModel = CompareFactory.eINSTANCE.createComparison();
                Match match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft((EObject)this.getWorkingModel());
                reviewResource.getContents().add((Object)this.diffModel);
            }
        }
        return this.diffModel;
    }

    public TransactionalEditingDomain getDomain() {
        return this.getCurrentModelSet().getTransactionalEditingDomain();
    }

    public void addAReview(final Element element) {
        this.getCurrentReviewModel();
        final Actor theauthor = this.getCurrentAuthor();
        RecordingCommand cmd = new RecordingCommand(this.getDomain(), "createAReview"){

            protected void doExecute() {
                Comment cmt = UMLFactory.eINSTANCE.createComment();
                cmt.setBody("Your review");
                if (element instanceof Comment) {
                    ((Comment)element).getOwnedComments().add((Object)cmt);
                } else {
                    ReviewResourceManager.this.reviewModel.getOwnedComments().add((Object)cmt);
                }
                Stereotype review = cmt.getApplicableStereotype("ReviewProfile::Review");
                cmt.applyStereotype(review);
                cmt.setValue(review, "subject", (Object)"subject");
                Stereotype authorStereotype = theauthor.getApplicableStereotype("PapyrusVersioningExtensions::Author");
                cmt.setValue(review, "author", (Object)theauthor.getStereotypeApplication(authorStereotype));
                Date today = new Date();
                DateFormat shortDateFormat = DateFormat.getDateTimeInstance(3, 3);
                cmt.setValue(review, "date", (Object)shortDateFormat.format(today));
            }
        };
        this.getDomain().getCommandStack().execute((Command)cmd);
    }

    public Actor getCurrentAuthor() {
        if (this.currentAuthor == null || this.currentAuthor.eContainer() == null) {
            final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String authorNamefromPreference = store.getString("AUTHOR_NAME");
            if (authorNamefromPreference.equals("Anonymous")) {
                CreateAuthorDialog authorDialog = new CreateAuthorDialog(new Shell());
                authorDialog.open();
            }
            final String authorName = store.getString("AUTHOR_NAME").trim();
            final Model reviewModel = this.getCurrentReviewModel();
            PackageableElement author = reviewModel.getPackagedElement(authorName);
            if (author == null || !(author instanceof Actor)) {
                RecordingCommand cmd = new RecordingCommand(this.getDomain(), "createReviewModel"){

                    protected void doExecute() {
                        ReviewResourceManager.this.currentAuthor = UMLFactory.eINSTANCE.createActor();
                        ReviewResourceManager.this.currentAuthor.setName(authorName.trim());
                        reviewModel.getPackagedElements().add((Object)ReviewResourceManager.this.currentAuthor);
                        Stereotype authorStereotype = ReviewResourceManager.this.currentAuthor.getApplicableStereotype("PapyrusVersioningExtensions::Author");
                        ReviewResourceManager.this.currentAuthor.applyStereotype(authorStereotype);
                        ReviewResourceManager.this.currentAuthor.setValue(authorStereotype, "language", (Object)store.getString("AUTHOR_LANGUAGE"));
                        RGB authorColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AUTHOR_COLOR");
                        String colorString = String.valueOf(authorColor.red) + ":" + authorColor.green + ":" + authorColor.blue;
                        ReviewResourceManager.this.currentAuthor.setValue(authorStereotype, "color", (Object)colorString);
                    }
                };
                this.getDomain().getCommandStack().execute((Command)cmd);
            } else {
                this.currentAuthor = (Actor)author;
            }
        }
        return this.currentAuthor;
    }

    public Model loadReviewModel() {
        Object object;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        PatternFilter UMLPattern = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (viewer != null) {
                    return super.isElementVisible(viewer, element);
                }
                return true;
            }
        };
        UMLPattern.setPattern("*.uml");
        dialog.setAllowMultiple(false);
        dialog.addFilter((ViewerFilter)UMLPattern);
        dialog.open();
        if (dialog.getResult().length > 0 && (object = dialog.getResult()[0]) instanceof IFile) {
            IFile aReviewModel = (IFile)object;
            Resource tmpResource = this.getCurrentModelSet().getResource(URI.createPlatformResourceURI((String)aReviewModel.getFullPath().toOSString(), (boolean)true), true);
            for (EObject contentEObject : tmpResource.getContents()) {
                if (!(contentEObject instanceof Model) || ((Model)contentEObject).getAppliedStereotype("ReviewProfile::ReviewRepository") == null) continue;
                this.reviewModel = (Model)contentEObject;
            }
        }
        this.getDomain().addResourceSetListener((ResourceSetListener)this.refreshFigureListener);
        return this.reviewModel;
    }

    public Model createReviewModel(final String reviewModelName) {
        RecordingCommand cmd = new RecordingCommand(this.getDomain(), "createReviewModel"){

            protected void doExecute() {
                URI umlModel_URI = ReviewResourceManager.this.getWorkingModel().eResource().getURI();
                String tmpURI = umlModel_URI.toString().replaceAll(umlModel_URI.lastSegment().toString(), String.valueOf(reviewModelName) + ".uml");
                URI reviewURI = URI.createURI((String)tmpURI);
                Resource resource = ReviewResourceManager.this.getCurrentModelSet().createResource(reviewURI);
                ReviewResourceManager.this.reviewModel = UMLFactory.eINSTANCE.createModel();
                ReviewResourceManager.this.reviewModel.setName(reviewModelName);
                RegisteredProfile registeredProfile = (RegisteredProfile)RegisteredProfile.getRegisteredProfile((String)"ReviewProfile");
                URI reviewProfileUri = registeredProfile.uri;
                Resource modelResource = ReviewResourceManager.this.getCurrentModelSet().getResource(reviewProfileUri, true);
                Profile reviewProfile = (Profile)modelResource.getContents().get(0);
                ReviewResourceManager.this.reviewModel.applyProfile(reviewProfile);
                ReviewResourceManager.this.reviewModel.applyStereotype(ReviewResourceManager.this.reviewModel.getApplicableStereotype("ReviewProfile::ReviewRepository"));
                EObject stereappl = ReviewResourceManager.this.reviewModel.getStereotypeApplication(ReviewResourceManager.this.reviewModel.getApplicableStereotype("ReviewProfile::ReviewRepository"));
                resource.getContents().add((Object)stereappl);
                registeredProfile = (RegisteredProfile)RegisteredProfile.getRegisteredProfile((String)"VersioningProfile");
                reviewProfileUri = registeredProfile.uri;
                modelResource = ReviewResourceManager.this.getCurrentModelSet().getResource(reviewProfileUri, true);
                reviewProfile = (Profile)modelResource.getContents().get(0);
                ReviewResourceManager.this.reviewModel.applyProfile(reviewProfile);
                Dependency dependency = UMLFactory.eINSTANCE.createDependency();
                dependency.getSuppliers().add((Object)ReviewResourceManager.this.getWorkingModel());
                dependency.getClients().add((Object)ReviewResourceManager.this.reviewModel);
                dependency.setName("WorkingModelDependency");
                ReviewResourceManager.this.reviewModel.getPackagedElements().add((Object)dependency);
                resource.getContents().add((Object)ReviewResourceManager.this.reviewModel);
                ReviewResourceManager.this.diffModel = CompareFactory.eINSTANCE.createComparison();
                Match match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft((EObject)ReviewResourceManager.this.getWorkingModel());
                resource.getContents().add((Object)ReviewResourceManager.this.diffModel);
            }
        };
        this.getDomain().getCommandStack().execute((Command)cmd);
        this.getDomain().addResourceSetListener((ResourceSetListener)this.refreshFigureListener);
        return this.reviewModel;
    }

    public Model getWorkingModel() {
        if (this.UMLWorkingModel != null) {
            return this.UMLWorkingModel;
        }
        this.modelSet = this.getCurrentModelSet();
        UmlModel IUMLModel = (UmlModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        try {
            this.UMLWorkingModel = (Model)IUMLModel.lookupRoot();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return this.UMLWorkingModel;
    }

    public ModelSet getCurrentModelSet() {
        if (this.modelSet != null) {
            return this.modelSet;
        }
        IWorkbenchPart part = this.getBootstrapPart();
        if (part instanceof IMultiDiagramEditor) {
            ServicesRegistry registry = ((IMultiDiagramEditor)part).getServicesRegistry();
            try {
                this.modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.modelSet;
    }

    public ServicesRegistry getServiceRegistry() {
        IWorkbenchPart part = this.getBootstrapPart();
        if (part instanceof IMultiDiagramEditor) {
            ServicesRegistry registry = ((IMultiDiagramEditor)part).getServicesRegistry();
            return registry;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IMultiDiagramEditor;
    }

    protected void compare(Model modelBefore, Model modelAfter) {
        IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher((UseIdentifiers)UseIdentifiers.NEVER);
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory());
        DefaultMatchEngine thematchEngine = new DefaultMatchEngine(matcher, (IComparisonFactory)comparisonFactory);
        IMatchEngine.Factory.Registry registry = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
        MatchEngineFactoryImpl engineFactory = new MatchEngineFactoryImpl((IMatchEngine)thematchEngine){
            private final /* synthetic */ IMatchEngine val$thematchEngine;
            {
                this.val$thematchEngine = iMatchEngine;
            }

            public IMatchEngine getMatchEngine() {
                return this.val$thematchEngine;
            }
        };
        engineFactory.setRanking(20);
        registry.add((IMatchEngine.Factory)engineFactory);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)modelBefore, (Notifier)modelAfter, null);
        final Comparison comparison = EMFCompare.builder().setMatchEngineFactoryRegistry(registry).build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Iterator iterator = differences.iterator();
        while (iterator.hasNext()) {
            Diff diff;
            Diff diffRef = diff = (Diff)iterator.next();
            System.out.println(diff);
        }
        RecordingCommand cmd = new RecordingCommand(this.getDomain(), "saveSnaphsot"){

            protected void doExecute() {
                URI umlModel_URI = ReviewResourceManager.this.getWorkingModel().eResource().getURI();
                String tmpURI = umlModel_URI.toString().replaceAll(umlModel_URI.lastSegment().toString(), "diff.xmi");
                URI reviewURI = URI.createURI((String)tmpURI);
                Resource resourcesnapshot = Util.createTemporaryResourceSet().createResource(reviewURI);
                resourcesnapshot.getContents().add((Object)comparison);
                try {
                    resourcesnapshot.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.getDomain().getCommandStack().execute((Command)cmd);
    }

    public void savediff() {
        RecordingCommand cmd = new RecordingCommand(this.getDomain(), "savediff"){

            protected void doExecute() {
                URI umlModel_URI = ReviewResourceManager.this.getWorkingModel().eResource().getURI();
                String tmpURIresultDiff = umlModel_URI.toString().replaceAll(umlModel_URI.lastSegment().toString(), "resultDiff.xmi");
                URI resultDiffURI = URI.createURI((String)tmpURIresultDiff);
                Resource resourceresultDiff = Util.createTemporaryResourceSet().createResource(resultDiffURI);
                resourceresultDiff.getContents().add((Object)ReviewResourceManager.this.diffModel);
                try {
                    resourceresultDiff.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public boolean modeRevisionRunning() {
        return this.modeRevisionRunning;
    }

    public void startModeRevision() {
        this.modeRevisionRunning = true;
        RecordingCommand cmd = new RecordingCommand(this.getDomain(), "savediff"){

            protected void doExecute() {
                if (ReviewResourceManager.this.getDiffModel().getMatches().size() == 0) {
                    Match match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft((EObject)ReviewResourceManager.this.getWorkingModel());
                    ReviewResourceManager.this.getDiffModel().getMatches().add((Object)match);
                }
            }
        };
        this.getDomain().getCommandStack().execute((Command)cmd);
        this.getDomain().addResourceSetListener((ResourceSetListener)this.addingDiffListener);
    }

    public void stopModelRevision() {
        this.modeRevisionRunning = false;
        this.getDomain().removeResourceSetListener((ResourceSetListener)this.addingDiffListener);
    }
}

