/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.revision.tool.Activator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CreateAuthorDialog
extends FormDialog {
    protected Text acronymText;
    protected Text languageText;
    protected Text chooseColor;
    protected IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    protected String defaultValue = "                                     ";

    public CreateAuthorDialog(Shell shell) {
        super(shell);
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText("Set author information");
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 2;
        parent.setLayout((Layout)lLayout);
        toolkit.createLabel(parent, "Acronym:");
        this.acronymText = toolkit.createText(parent, this.defaultValue);
        toolkit.createLabel(parent, "Language:");
        this.languageText = toolkit.createText(parent, this.defaultValue);
        toolkit.createLabel(parent, "Color:");
        this.chooseColor = toolkit.createText(parent, this.defaultValue, 524288);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.store, (String)"AUTHOR_COLOR");
        Display device = Display.getCurrent();
        this.chooseColor.setBackground(new Color((Device)device, rgb));
        this.addListeners();
        scrolledForm.reflow(true);
        this.languageText.setText(this.store.getString("AUTHOR_LANGUAGE"));
    }

    protected void addListeners() {
        this.chooseColor.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.getSource().equals(CreateAuthorDialog.this.chooseColor)) {
                    ColorDialog cd = new ColorDialog(new Shell());
                    cd.setText("Choose color");
                    cd.setRGB(new RGB(255, 255, 255));
                    RGB newColor = cd.open();
                    if (newColor == null) {
                        return;
                    }
                    Display device = Display.getCurrent();
                    CreateAuthorDialog.this.chooseColor.setBackground(new Color((Device)device, newColor));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void okPressed() {
        if (this.acronymText.getText().trim() != "" && this.languageText.getText().trim() != "") {
            this.store.setValue("AUTHOR_NAME", this.acronymText.getText());
            this.store.setValue("AUTHOR_LANGUAGE", this.languageText.getText());
            PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)"AUTHOR_COLOR", (RGB)this.chooseColor.getBackground().getRGB());
        }
        super.okPressed();
    }
}

