/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.revision.tool.core.ReviewResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;

public class CreateOrSelectReviewModelDialog
extends FormDialog {
    protected ArrayList<Profile> appliedLocalProfiles;
    protected Button creationRadio;
    protected Text newTypeNameText;
    protected Label newProfileLabel;
    protected Button selectionRadio;
    protected Label profileSelectionLabel;
    protected Section lSection;
    protected String resultReviewName;
    protected Button reviewSeletion;
    protected ReviewResourceManager reviewResourceManager;

    public CreateOrSelectReviewModelDialog(Shell shell, ReviewResourceManager reviewResourceManager) {
        super(shell);
        this.reviewResourceManager = reviewResourceManager;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText("Review Model Selection");
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createFormCreationSection(scrolledForm.getBody(), toolkit);
        this.createFormSelectionSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(false);
        this.addListeners();
        scrolledForm.reflow(true);
    }

    protected void refreshSectionsEnable(boolean selectionEnable) {
        this.creationRadio.setSelection(false);
        this.selectionRadio.setSelection(false);
        this.creationRadio.setSelection(!selectionEnable);
        this.newTypeNameText.setEnabled(!selectionEnable);
        this.newProfileLabel.setEnabled(!selectionEnable);
        if (!selectionEnable) {
            this.newTypeNameText.setFocus();
        }
        this.selectionRadio.setSelection(selectionEnable);
        this.profileSelectionLabel.setEnabled(selectionEnable);
        this.reviewSeletion.setEnabled(selectionEnable);
        if (selectionEnable) {
            this.reviewSeletion.setFocus();
        }
    }

    protected void addListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateOrSelectReviewModelDialog.this.creationRadio.equals(e.getSource())) {
                    CreateOrSelectReviewModelDialog.this.refreshSectionsEnable(false);
                } else {
                    CreateOrSelectReviewModelDialog.this.refreshSectionsEnable(true);
                }
                CreateOrSelectReviewModelDialog.this.refreshOkButton();
            }
        };
        SelectionAdapter ChooseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateOrSelectReviewModelDialog.this.reviewSeletion.equals(e.getSource())) {
                    CreateOrSelectReviewModelDialog.this.reviewResourceManager.loadReviewModel();
                    Model reviewModel = CreateOrSelectReviewModelDialog.this.reviewResourceManager.getCurrentReviewModel();
                    CreateOrSelectReviewModelDialog.this.reviewSeletion.setText("Choose " + reviewModel.getName());
                }
                CreateOrSelectReviewModelDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.creationRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.reviewSeletion.addSelectionListener((SelectionListener)ChooseListener);
        ModifyListener lNewNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOrSelectReviewModelDialog.this.refreshOkButton();
            }
        };
        this.newTypeNameText.addModifyListener(lNewNameListener);
    }

    protected void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (!isSelectionSelected) {
            if (this.newTypeNameText.getText().trim().equals("")) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected void createFormCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = "Create a new Review Model";
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, "Review Model creation", 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.newProfileLabel = pToolkit.createLabel(lBody, "Set name of the new review model", 0);
        this.newTypeNameText = pToolkit.createText(lBody, "", 2048);
        this.newTypeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.newTypeNameText.setFocus();
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void createFormSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = "Select an existing Review Model";
        this.lSection = pToolkit.createSection(pParent, 320);
        this.lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            this.lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)this.lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, "Selection Review Model mode", 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.profileSelectionLabel = pToolkit.createLabel(lBody, "Review:", 0);
        this.reviewSeletion = pToolkit.createButton(lBody, "Choose...                                        ", 524288);
        try {
            ImageDescriptor imfDesc = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.papyrus.revisiontool/img/load.png"));
            this.reviewSeletion.setImage(imfDesc.createImage());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        pToolkit.adapt((Control)this.reviewSeletion, true, true);
        lInsideScrolledForm.reflow(true);
        this.lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.resultReviewName = null;
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (!isSelectionSelected && !this.newTypeNameText.getText().trim().equals("")) {
            this.resultReviewName = this.newTypeNameText.getText().trim();
            this.reviewResourceManager.createReviewModel(this.resultReviewName);
        }
        super.okPressed();
    }
}

