/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.revision.tool.core.ReviewResourceManager;
import org.eclipse.papyrus.revision.tool.handlers.RevisionAbstractHandler;
import org.eclipse.papyrus.revision.tool.ui.ReviewsEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AcceptReviewHandler
extends RevisionAbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ArrayList<Element> elements = this.getSelectionSet();
        final IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ReviewsEditor && elements.size() != 0) {
            RecordingCommand cmd = new RecordingCommand(((ReviewsEditor)part).getReviewResourceManager().getDomain(), "Refuse currentReview"){

                protected void doExecute() {
                    for (Element element : elements) {
                        String diffuriFragment;
                        Stereotype reviewtoDo = element.getAppliedStereotype("ReviewProfile::Todo");
                        if (reviewtoDo == null || (diffuriFragment = (String)element.getValue(reviewtoDo, "diffRef")) == null) continue;
                        EObject eOject = element.eResource().getEObject(diffuriFragment);
                        if (eOject instanceof ReferenceChange) {
                            ReferenceChange referenceChange = (ReferenceChange)eOject;
                            if (referenceChange.getKind().equals((Object)DifferenceKind.DELETE)) {
                                AcceptReviewHandler.this.acceptDelete(part, element, referenceChange);
                                continue;
                            }
                            if (!referenceChange.getKind().equals((Object)DifferenceKind.ADD)) continue;
                            AcceptReviewHandler.this.removeDiffAndReview(part, element, referenceChange);
                            continue;
                        }
                        if (!(eOject instanceof Match)) continue;
                        ReviewResourceManager r = ((ReviewsEditor)part).getReviewResourceManager();
                        AcceptReviewHandler.this.removeMatchAndReview(eOject, r, element);
                    }
                }
            };
            ((ReviewsEditor)part).getReviewResourceManager().getDomain().getCommandStack().execute((Command)cmd);
        }
        return null;
    }

    protected void removeDiffAndReview(IWorkbenchPart part, Element element, ReferenceChange referenceChange) {
        ReviewResourceManager r = ((ReviewsEditor)part).getReviewResourceManager();
        Match modelMatch = r.getDiffModel().getMatch((EObject)r.getWorkingModel());
        modelMatch.getDifferences().remove((Object)referenceChange);
        ((Element)element.eContainer()).getOwnedComments().remove((Object)element);
    }

    protected void acceptDelete(IWorkbenchPart part, Element element, ReferenceChange referenceChange) {
        ICommand deleteCommand;
        ReviewResourceManager r = ((ReviewsEditor)part).getReviewResourceManager();
        EObject eObjectToRemove = referenceChange.getValue();
        this.removeDiffAndReview(part, element, referenceChange);
        DestroyElementRequest destroyrequest = new DestroyElementRequest(false);
        destroyrequest.setEditingDomain(r.getDomain());
        destroyrequest.setElementToDestroy(eObjectToRemove);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)eObjectToRemove);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)destroyrequest)) != null) {
            try {
                deleteCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    protected void removeMatchAndReview(EObject eOject, ReviewResourceManager r, Element element) {
        Match modelMatch = r.getDiffModel().getMatch((EObject)r.getWorkingModel());
        modelMatch.getSubmatches().remove((Object)((Match)eOject));
        ((Element)element.eContainer()).getOwnedComments().remove((Object)element);
    }
}

