/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.revision.tool.core.ReviewResourceManager;
import org.eclipse.papyrus.revision.tool.ui.ReviewsTreeContentProvider;
import org.eclipse.papyrus.revision.tool.ui.ReviewsTreeLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;

public class ReviewsEditor
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    protected static final String ORG_ECLIPSE_PAPYRUS_REVISIONTOOL = "org.eclipse.papyrus.revisiontool";
    protected ReviewResourceManager reviewResourceManager = new ReviewResourceManager();
    private TreeViewer viewer;
    protected List<IPropertySheetPage> propertySheetPages = new ArrayList<IPropertySheetPage>();
    protected ResourceSetListenerImpl reviewEditorResourceListener = null;

    private static FontData[] getModifiedFontData(FontData[] originalData, int additionalStyle) {
        FontData[] styleData = new FontData[originalData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = originalData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | additionalStyle);
            ++i;
        }
        return styleData;
    }

    public ReviewResourceManager getReviewResourceManager() {
        return this.reviewResourceManager;
    }

    public void dispose() {
        this.reviewResourceManager.getDomain().removeResourceSetListener(this.getResourceListener());
        this.reviewResourceManager.dispose();
        this.reviewResourceManager = null;
        super.dispose();
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReviewsEditor.this.filterContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    protected void filterContextMenu(IMenuManager mgr) {
        IContributionItem[] contributionItems = mgr.getItems();
        int i = 0;
        while (i < contributionItems.length) {
            if (!contributionItems[i].getId().startsWith(ORG_ECLIPSE_PAPYRUS_REVISIONTOOL)) {
                mgr.remove(contributionItems[i]);
            }
            ++i;
        }
    }

    public ResourceSetListener getResourceListener() {
        if (this.reviewEditorResourceListener == null) {
            this.reviewEditorResourceListener = new ResourceSetListenerImpl(){

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    HashSet<Resource> notifiers = new HashSet<Resource>();
                    boolean closeSignal = false;
                    for (Notification notification : event.getNotifications()) {
                        if (notification.getNotifier() instanceof EObject) {
                            notifiers.add(((EObject)notification.getNotifier()).eResource());
                        }
                        if (!(notification.getNotifier() instanceof Resource) || ReviewsEditor.this.reviewResourceManager.getWorkingModel().eResource() != null || notification.getEventType() != 6) continue;
                        closeSignal = true;
                    }
                    for (Resource currentResource : notifiers) {
                        if (!ReviewsEditor.this.reviewResourceManager.getCurrentReviewModel().eResource().equals(currentResource)) continue;
                        ReviewsEditor.this.viewer.setInput((Object)ReviewsEditor.this.reviewResourceManager.getCurrentReviewModel());
                    }
                    if (closeSignal) {
                        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.papyrus.revisiontool.commentview");
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(part);
                    }
                }

                public boolean isPostcommitOnly() {
                    return true;
                }
            };
        }
        return this.reviewEditorResourceListener;
    }

    public void addAReview(Element container) {
        this.reviewResourceManager.addAReview(container);
        this.viewer.setInput((Object)this.reviewResourceManager.getCurrentReviewModel());
        this.reviewResourceManager.getDomain().addResourceSetListener(this.getResourceListener());
    }

    public void createActions() {
        Action loadReview = new Action("Load a review model"){

            public void run() {
                Model reviewModel = ReviewsEditor.this.reviewResourceManager.loadReviewModel();
                ReviewsEditor.this.viewer.setInput((Object)reviewModel);
                ReviewsEditor.this.reviewResourceManager.getDomain().addResourceSetListener(ReviewsEditor.this.getResourceListener());
            }

            public String getDescription() {
                return "Load a review Model";
            }
        };
        Action addReview = new Action("Add a review"){

            public void run() {
                ReviewsEditor.this.addAReview(null);
            }

            public String getDescription() {
                return "Add a review";
            }
        };
        try {
            loadReview.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.papyrus.revisiontool/img/load.png")));
            addReview.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.papyrus.revisiontool/img/Add.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)loadReview);
        mgr.add((IAction)addReview);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new ReviewsTreeContentProvider());
        FontData[] boldFontData = ReviewsEditor.getModifiedFontData(this.viewer.getTree().getFont().getFontData(), 1);
        FontData[] italicFontData = ReviewsEditor.getModifiedFontData(this.viewer.getTree().getFont().getFontData(), 2);
        Font boldFont = new Font((Device)Display.getCurrent(), boldFontData);
        Font italicFont = new Font((Device)Display.getCurrent(), italicFontData);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReviewsTreeLabelProvider(boldFont, italicFont));
        this.createContextMenu();
        this.createActions();
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TreeItem item = (TreeItem)event.item;
                        String text = item.getText();
                        Point size = event.gc.textExtent(text);
                        event.width = size.x + 20;
                        event.height = Math.max(event.height, size.y);
                        break;
                    }
                    case 42: {
                        TreeItem item = (TreeItem)event.item;
                        String text = item.getText();
                        Point size = event.gc.textExtent(text);
                        int offset2 = event.index == 0 ? Math.max(0, (event.height - size.y) / 2) : 0;
                        event.gc.drawText(text, event.x, event.y + offset2, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }
        };
        this.viewer.getTree().addListener(41, paintListener);
        this.viewer.getTree().addListener(40, paintListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void startModeRevision() {
        this.viewer.setInput((Object)this.reviewResourceManager.getCurrentReviewModel());
        this.reviewResourceManager.getDomain().addResourceSetListener(this.getResourceListener());
        this.reviewResourceManager.startModeRevision();
    }

    public void stopModelRevision() {
        this.viewer.setInput((Object)this.reviewResourceManager.getCurrentReviewModel());
        this.reviewResourceManager.getDomain().addResourceSetListener(this.getResourceListener());
        this.reviewResourceManager.stopModelRevision();
    }

    private IPropertySheetPage getPropertySheetPage() {
        try {
            IMultiDiagramEditor multiDiagramEditor = (IMultiDiagramEditor)this.getReviewResourceManager().getServiceRegistry().getService(IMultiDiagramEditor.class);
            if (multiDiagramEditor != null && multiDiagramEditor instanceof ITabbedPropertySheetPageContributor) {
                ITabbedPropertySheetPageContributor contributor = (ITabbedPropertySheetPageContributor)multiDiagramEditor;
                TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage(contributor);
                this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
                return propertySheetPage;
            }
        }
        catch (ServiceException ex) {
            System.err.println((Object)ex);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void setFocus() {
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }
}

