/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.ui;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ReviewsTreeLabelProvider
extends StyledCellLabelProvider {
    protected Font italicFont;
    protected Font boldFont;
    private StyledString.Styler fBoldStyler;
    private StyledString.Styler fItalicStyler;

    public ReviewsTreeLabelProvider(final Font boldFont, final Font italicFont) {
        this.boldFont = boldFont;
        this.italicFont = italicFont;
        this.fBoldStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = boldFont;
            }
        };
        this.fItalicStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = italicFont;
            }
        };
    }

    public Color getColorFromAuthor(Actor author) {
        String colorRGB;
        Display device = Display.getCurrent();
        if (author != null && (colorRGB = (String)author.getValue(author.getApplicableStereotype("PapyrusVersioningExtensions::Author"), "color")) != null) {
            String R = colorRGB.substring(0, colorRGB.indexOf(":"));
            colorRGB = colorRGB.substring(colorRGB.indexOf(":") + 1);
            String G = colorRGB.substring(0, colorRGB.indexOf(":"));
            String B = colorRGB = colorRGB.substring(colorRGB.indexOf(":") + 1);
            return new Color((Device)device, new Integer(R).intValue(), new Integer(G).intValue(), new Integer(B).intValue());
        }
        return new Color((Device)device, 255, 255, 255);
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        if (obj instanceof Comment) {
            StyledString styledString;
            Comment cmt = (Comment)obj;
            Stereotype theReviewStereotype = cmt.getApplicableStereotype("ReviewProfile::Comment");
            Stereotype reviewStereotype = null;
            EList stereotypes = cmt.getAppliedStereotypes();
            System.out.println(cmt);
            for (Stereotype stereotype : stereotypes) {
                if (!stereotype.getGenerals().contains((Object)theReviewStereotype)) continue;
                reviewStereotype = stereotype;
            }
            if (reviewStereotype != null) {
                styledString = new StyledString("");
                EObject stereotypeApplicationAuthor = (EObject)cmt.getValue(reviewStereotype, "author");
                if (stereotypeApplicationAuthor != null) {
                    Actor author = (Actor)UMLUtil.getBaseElement((EObject)stereotypeApplicationAuthor);
                    if (author != null) {
                        styledString.append(author.getName(), this.fBoldStyler);
                    }
                    cell.setBackground(this.getColorFromAuthor(author));
                } else {
                    styledString.append("No author", this.fBoldStyler);
                }
                if (cmt.getValue(reviewStereotype, "subject") != null) {
                    styledString.append(" " + cmt.getValue(reviewStereotype, "subject"), this.fItalicStyler);
                } else {
                    styledString.append(" No subject", this.fItalicStyler);
                }
                if (cmt.getValue(reviewStereotype, "date") != null) {
                    styledString.append(" " + cmt.getValue(reviewStereotype, "date"), this.fBoldStyler);
                }
                styledString.append(" (" + cmt.getOwnedComments().size() + ")", StyledString.COUNTER_STYLER);
                styledString.append("\n" + cmt.getBody(), StyledString.DECORATIONS_STYLER);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else {
                styledString = new StyledString("");
                styledString.append(cmt.getBody(), StyledString.DECORATIONS_STYLER);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        }
        super.update(cell);
    }
}

