/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.revision.tool.ui;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.revision.tool.core.ReviewResourceManager;
import org.eclipse.papyrus.revision.tool.ui.AddingFig;
import org.eclipse.papyrus.revision.tool.ui.RemovedFig;
import org.eclipse.papyrus.revision.tool.ui.SetFig;
import org.eclipse.papyrus.uml.diagram.common.part.UmlGmfDiagramEditor;

public class RevisonDiagLayer {
    public void run(ReviewResourceManager reviewResourceManager) {
        IMultiDiagramEditor multiDiagramEditor = null;
        try {
            multiDiagramEditor = (IMultiDiagramEditor)reviewResourceManager.getServiceRegistry().getService(IMultiDiagramEditor.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        UmlGmfDiagramEditor diagramEditor = (UmlGmfDiagramEditor)multiDiagramEditor.getActiveEditor();
        DiagramEditPart diagramEditPart = (DiagramEditPart)diagramEditor.getAdapter(DiagramEditPart.class);
        this.updateEditpart(reviewResourceManager, (EditPart)diagramEditPart);
    }

    protected void updateEditpart(ReviewResourceManager reviewResourceManager, EditPart editPart) {
        IFigure fig;
        EObject semanticEObject;
        for (Object subEditPart : editPart.getChildren()) {
            if (!(subEditPart instanceof GraphicalEditPart)) continue;
            semanticEObject = ((GraphicalEditPart)subEditPart).resolveSemanticElement();
            fig = ((GraphicalEditPart)subEditPart).getFigure();
            if (!(subEditPart instanceof CompartmentEditPart)) {
                this.updateFigures(reviewResourceManager, subEditPart, semanticEObject, fig);
            }
            this.updateEditpart(reviewResourceManager, (EditPart)((GraphicalEditPart)subEditPart));
        }
        if (editPart instanceof DiagramEditPart) {
            for (Object connetionEditPart : ((DiagramEditPart)editPart).getConnections()) {
                if (!(connetionEditPart instanceof ConnectionEditPart)) continue;
                semanticEObject = ((ConnectionEditPart)connetionEditPart).resolveSemanticElement();
                fig = ((ConnectionEditPart)connetionEditPart).getFigure();
                this.updateFigures(reviewResourceManager, connetionEditPart, semanticEObject, fig);
            }
        }
    }

    protected void updateFigures(ReviewResourceManager reviewResourceManager, Object editPart, EObject semanticEObject, IFigure fig) {
        Comparison comparison = reviewResourceManager.getDiffModel();
        RemovedFig removedFig = null;
        AddingFig addingFig = null;
        SetFig setFig = null;
        for (Object subFig : fig.getChildren()) {
            if (subFig instanceof RemovedFig) {
                removedFig = (RemovedFig)((Object)subFig);
            }
            if (subFig instanceof AddingFig) {
                addingFig = (AddingFig)((Object)subFig);
            }
            if (!(subFig instanceof SetFig)) continue;
            setFig = (SetFig)((Object)subFig);
        }
        if (comparison.getMatch(semanticEObject) != null) {
            if (setFig == null) {
                setFig = new SetFig("Bob");
                fig.add((IFigure)setFig);
            }
            this.setFigurePosition(editPart, fig, (IFigure)setFig);
        } else if (setFig != null) {
            fig.remove(setFig);
        }
        if (comparison.getDifferences(semanticEObject).size() > 0) {
            Diff diff = (Diff)comparison.getDifferences(semanticEObject).get(0);
            if (diff.getKind().equals((Object)DifferenceKind.DELETE) && this.isChangeAboutContaiment(comparison, semanticEObject)) {
                if (removedFig == null) {
                    removedFig = new RemovedFig();
                    fig.add((IFigure)removedFig);
                }
                this.setFigurePosition(editPart, fig, (IFigure)removedFig);
            } else if (diff.getKind().equals((Object)DifferenceKind.ADD) && this.isChangeAboutContaiment(comparison, semanticEObject)) {
                if (addingFig == null) {
                    addingFig = new AddingFig();
                    fig.add((IFigure)addingFig);
                }
                this.setFigurePosition(editPart, fig, (IFigure)addingFig);
            } else {
                if (removedFig != null) {
                    fig.remove((IFigure)removedFig);
                }
                if (addingFig != null) {
                    fig.remove((IFigure)addingFig);
                }
            }
        } else {
            if (removedFig != null) {
                fig.remove((IFigure)removedFig);
            }
            if (addingFig != null) {
                fig.remove((IFigure)addingFig);
            }
        }
    }

    protected boolean isChangeAboutContaiment(Comparison comparison, EObject element) {
        ReferenceChange refChange;
        return comparison.getDifferences(element).get(0) instanceof ReferenceChange && (refChange = (ReferenceChange)comparison.getDifferences(element).get(0)).getReference().isContainment();
    }

    protected void setFigurePosition(Object editPart, IFigure fig, IFigure addingFig) {
        if (fig instanceof PolylineConnectionEx) {
            Rectangle rect = new Rectangle(((PolylineConnectionEx)fig).getPoints().getFirstPoint(), ((PolylineConnectionEx)fig).getPoints().getLastPoint());
            if (rect.x == 0 && rect.y == 0 && editPart instanceof ConnectionEditPart) {
                rect = ((GraphicalEditPart)((ConnectionEditPart)editPart).getSource()).getFigure().getBounds().getCopy();
                rect = rect.getUnion(((GraphicalEditPart)((ConnectionEditPart)editPart).getTarget()).getFigure().getBounds());
            }
            addingFig.setBounds(rect);
        } else {
            addingFig.setBounds(fig.getBounds());
        }
    }
}

