/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.HashMap;
import java.util.Map;

public class Log {
    public static final int ERROR_MSG = 1;
    public static final int INFO_MSG = 2;
    public static final int WARNING_MSG = 4;
    public static final int TRAFO_CONNECTOR = 1;
    public static final int TRAFO_CONTAINER = 2;
    public static final int TRAFO_COPY = 4;
    public static final int TRAFO_SYNC = 8;
    public static final int TEMPLATE_BINDING = 16;
    public static final int TEMPLATE_INSTANTIATION = 32;
    public static final int DEPLOYMENT = 64;
    public static final int DIALOGS = 128;
    public static final int UTILS = 256;
    public static final int CODEGEN = 512;
    public static final int CALC_PORTKIND = 1024;
    static Map<Integer, String> moduleMap;
    static int moduleFilter;

    static {
        moduleFilter = 0;
    }

    static String getModuleInfo(int moduleKind) {
        if (moduleMap == null) {
            moduleMap = new HashMap<Integer, String>();
            moduleMap.put(1, "Trafo connector");
            moduleMap.put(2, "Trafo container");
            moduleMap.put(4, "Trafo copy");
            moduleMap.put(8, "Synchronization");
            moduleMap.put(16, "Template binding");
            moduleMap.put(32, "Template instantiation");
            moduleMap.put(64, "Template binding");
            moduleMap.put(128, "Qompass dialogs");
            moduleMap.put(256, "Utils");
            moduleMap.put(512, "Code generation");
            moduleMap.put(1024, "Calculate portkind");
        }
        return "Module " + moduleMap.get(moduleKind) + ": ";
    }

    public static void log(int msgKind, int moduleKind, String message) {
        if (msgKind == 1) {
            System.err.println(String.valueOf(Log.getModuleInfo(moduleKind)) + message);
        } else if (msgKind == 2 && (moduleKind & moduleFilter) != 0) {
            System.out.println(String.valueOf(Log.getModuleInfo(moduleKind)) + message);
        }
    }
}

