/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.dialog;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.deployment.AllocUtils;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.DialogUtils;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;

public class AllocationDialog
extends SelectionStatusDialog {
    private DeploymentPlan m_cdp;
    private Tree fTree;
    private Label fLabel;
    private Combo fAlloc;
    private InstanceSpecification currentIS;
    private EList<InstanceSpecification> nodeOrThreadList;
    private EList<Package> visitedPackages;

    public AllocationDialog(Shell parent, Package cdp) {
        super(parent);
        this.m_cdp = StUtils.getApplication((Element)cdp, DeploymentPlan.class);
        this.visitedPackages = new BasicEList();
        this.nodeOrThreadList = new BasicEList();
        this.nodeOrThreadList.add(null);
        this.getAllNodesOrThreads((Package)cdp.getModel(), this.nodeOrThreadList);
    }

    protected void computeResult() {
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.fTree = new Tree(contents, 2304);
        this.fTree.setHeaderVisible(true);
        GridData data = new GridData(1808);
        this.fTree.setLayoutData((Object)data);
        data.heightHint = 150;
        this.fTree.setRedraw(false);
        TreeColumn instances = new TreeColumn(this.fTree, 16384);
        instances.setText("Instance");
        instances.setWidth(200);
        TreeColumn explicitAlloc = new TreeColumn(this.fTree, 16384);
        explicitAlloc.setText("explicit allocation");
        explicitAlloc.setWidth(150);
        TreeColumn implicitAlloc = new TreeColumn(this.fTree, 16384);
        implicitAlloc.setText("implicit allocation");
        implicitAlloc.setWidth(150);
        this.fillTree(this.fTree, null, this.m_cdp.getMainInstance());
        this.fTree.setRedraw(true);
        this.fTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AllocationDialog.this.fTree.getSelection().length > 0) {
                    AllocationDialog.this.selectInstance(AllocationDialog.this.fTree.getSelection()[0]);
                }
            }
        });
        Label label = new Label();
        label.setText("seletected instance:");
        this.fLabel = new Label();
        this.createAllocInfo(contents);
        return contents;
    }

    private void fillTree(Tree tree, TreeItem treeItem, InstanceSpecification is) {
        TreeItem item = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(tree, 0);
        item.setData((Object)is);
        this.setTextFromData(item);
        for (InstanceSpecification subIS : DepUtils.getContainedInstances(is)) {
            this.fillTree(tree, item, subIS);
        }
    }

    protected void setTextFromData(TreeItem ti) {
        Object data = ti.getData();
        if (data instanceof InstanceSpecification) {
            InstanceSpecification is = (InstanceSpecification)data;
            String name = is.getName();
            int index = name.lastIndexOf(".");
            if (index != -1) {
                name = name.substring(index + 1);
            }
            InstanceSpecification explicitNodeOrThread = AllocUtils.getNodeOrThread(is);
            Classifier cl = DepUtils.getClassifier(is);
            String nodeName = explicitNodeOrThread == null ? "-" : this.getAllocName(explicitNodeOrThread);
            EList<InstanceSpecification> implicitNodes = AllocUtils.getAllNodesOrThreadsParent(is);
            implicitNodes.addAll(AllocUtils.getAllNodesOrThreadsParent(is));
            String list = "";
            for (InstanceSpecification node : implicitNodes) {
                list = list.equals("") ? this.getAllocName(node) : String.valueOf(list) + ", " + this.getAllocName(node);
            }
            ti.setText(new String[]{name, nodeName, "[" + list + "]"});
        }
    }

    protected void refreshTree(TreeItem ti) {
        this.setTextFromData(ti);
        TreeItem[] treeItemArray = ti.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            this.refreshTree(subItem);
            ++n2;
        }
    }

    private String getAllocName(InstanceSpecification nodeOrThread) {
        if (nodeOrThread == null) {
            return "no explicit allocation";
        }
        String name = nodeOrThread.getName();
        InstanceSpecification threadNode = AllocUtils.getNode(nodeOrThread);
        return String.valueOf(name) + (threadNode != null ? " on " + threadNode.getName() : "");
    }

    protected void createAllocInfo(Composite parent) {
        this.fAlloc = DialogUtils.createComboWithText(parent, "Alloc to node:", 12, 0);
        String[] items = new String[this.nodeOrThreadList.size()];
        int i = 0;
        for (InstanceSpecification nodeOrThread : this.nodeOrThreadList) {
            items[i++] = this.getAllocName(nodeOrThread);
        }
        this.fAlloc.setItems(items);
        this.fAlloc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AllocationDialog.this.currentIS != null) {
                    AllocationDialog.this.updateAllocation(AllocationDialog.this.currentIS, AllocationDialog.this.fAlloc.getSelectionIndex());
                    TreeItem[] treeItemArray = AllocationDialog.this.fTree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        AllocationDialog.this.refreshTree(ti);
                        ++n2;
                    }
                }
            }
        });
        this.fAlloc.setEnabled(false);
    }

    protected void selectInstance(TreeItem item) {
        this.currentIS = (InstanceSpecification)item.getData();
        this.fLabel.setText(this.currentIS.getName());
        this.fAlloc.setEnabled(true);
        InstanceSpecification nodeOrThread = AllocUtils.getNodeOrThread(this.currentIS);
        int i = 0;
        while (i < this.nodeOrThreadList.size()) {
            if (this.nodeOrThreadList.get(i) == nodeOrThread) {
                this.fAlloc.select(i);
            }
            ++i;
        }
    }

    private void updateAllocation(InstanceSpecification is, int index) {
        InstanceSpecification newNode;
        InstanceSpecification oldNode = AllocUtils.getNodeOrThread(is);
        if (oldNode == (newNode = (InstanceSpecification)this.nodeOrThreadList.get(index))) {
            return;
        }
        if (oldNode == null) {
            AllocUtils.allocate(is, newNode);
        } else {
            AllocUtils.updateAllocation(is, oldNode, newNode);
        }
    }

    void getAllNodesOrThreads(Package pkg, EList<InstanceSpecification> nodeList) {
        for (Element el : pkg.getMembers()) {
            Classifier cl;
            if (el instanceof Package) {
                if (this.visitedPackages.contains((Object)el)) continue;
                this.visitedPackages.add((Object)((Package)el));
                this.getAllNodesOrThreads((Package)el, nodeList);
                continue;
            }
            if (!(el instanceof InstanceSpecification) || (cl = DepUtils.getClassifier((InstanceSpecification)el)) == null || !(cl instanceof Class) || StUtils.isApplied(el.getOwner(), DeploymentPlan.class)) continue;
            nodeList.add((Object)((InstanceSpecification)el));
        }
    }
}

