/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.robotml.deployment.CommandSupport;
import org.eclipse.papyrus.robotml.deployment.RunnableWithResult;
import org.eclipse.papyrus.robotml.deployment.dialog.ConfigureInstanceDialog;
import org.eclipse.papyrus.robotml.deployment.handlers.CmdHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class ConfigureInstanceHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        EObject selectedObj = this.getSelectedEObject();
        return selectedObj instanceof Class || selectedObj instanceof Connector || selectedObj instanceof Property || selectedObj instanceof InstanceSpecification;
    }

    @Override
    public Object execute(ExecutionEvent event) {
        if (!(this.getSelectedEObject() instanceof NamedElement)) {
            return null;
        }
        final NamedElement element = (NamedElement)this.getSelectedEObject();
        final Shell shell = new Shell();
        if (element instanceof Class) {
            CommandSupport.exec("Configure associated component instance", new RunnableWithResult(){

                @Override
                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Class)element)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for component " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        } else if (element instanceof Feature) {
            CommandSupport.exec("Configure associated instance", new RunnableWithResult(){

                @Override
                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Feature)element)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for property/connector " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        } else if (element instanceof InstanceSpecification) {
            CommandSupport.exec("Configure instance", new RunnableWithResult(){

                @Override
                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((InstanceSpecification)element)) {
                        configureInstanceDialog.setMessage("Configure instance " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        }
        return null;
    }
}

