/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.diagram.common.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class RobotMLReconciler
extends DiagramReconciler {
    private static final String OLD_ARCHITECTURE_TYPE = "architecture";
    private static final String OLD_COMPONENT_TYPE = "componentdef";
    private static final String OLD_INTERFACE_TYPE = "InterfaceDef";
    private static final String OLD_DATATYPE_TYPE = "DatatypeDef";
    private static final String NEW_CLASS_DIAGRAM = "PapyrusUMLClassDiagram";
    private static final String NEW_COMPOSITE_DIAGRAM = "CompositeStructure";
    private static final MigrationData ARCHITECTURE = new MigrationData("architecture", "CompositeStructure", "RobotML Architecture");
    private static final MigrationData COMPONENT = new MigrationData("componentdef", "CompositeStructure", "RobotML Component");
    private static final MigrationData INTERFACE = new MigrationData("InterfaceDef", "PapyrusUMLClassDiagram", "RobotML Interface");
    private static final MigrationData DATATYPE = new MigrationData("DatatypeDef", "PapyrusUMLClassDiagram", "RobotML Datatype");
    private static final Map<String, MigrationData> ourMigrations = new HashMap<String, MigrationData>();

    static {
        MigrationData[] migrationDataArray = new MigrationData[]{ARCHITECTURE, COMPONENT, INTERFACE, DATATYPE};
        int n = migrationDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            MigrationData next = migrationDataArray[n2];
            ourMigrations.put(RobotMLReconciler.safeToLowerCase(next.getOldType()), next);
            ++n2;
        }
    }

    public ICommand getReconcileCommand(Diagram diagram) {
        MigrationData data = this.findMigration(diagram);
        return data == null ? null : new RobotMLReconcileCommand(diagram, data);
    }

    private MigrationData findMigration(Diagram diagram) {
        return ourMigrations.get(RobotMLReconciler.safeToLowerCase(diagram.getType()));
    }

    private static String safeToLowerCase(String text) {
        return text == null ? null : text.toLowerCase();
    }

    private static class MigrationData {
        private ViewPrototype myCachedPrototype;
        private final String myNewType;
        private final String myOldType;
        private final String myPrototypeLabel;

        public MigrationData(String oldType, String newType, String prototypeLabel) {
            this.myOldType = oldType;
            this.myNewType = newType;
            this.myPrototypeLabel = prototypeLabel;
        }

        public String getPrototypeLabel() {
            return this.myPrototypeLabel;
        }

        public String getOldType() {
            return this.myOldType;
        }

        public String getNewType() {
            return this.myNewType;
        }

        public ViewPrototype getPrototype() {
            if (this.myCachedPrototype == null) {
                this.myCachedPrototype = MigrationData.findPrototype(this.myPrototypeLabel);
            }
            return this.myCachedPrototype;
        }

        private static ViewPrototype findPrototype(String label) {
            for (ViewPrototype proto : PolicyChecker.getCurrent().getAllPrototypes()) {
                if (!proto.getLabel().contains(label)) continue;
                return proto;
            }
            return null;
        }
    }

    private static class RobotMLReconcileCommand
    extends AbstractCommand {
        private final Diagram myDiagram;
        private final MigrationData myMigrationData;

        public RobotMLReconcileCommand(Diagram diagram, MigrationData data) {
            super("Migrate old RobotML diagram");
            this.myDiagram = diagram;
            this.myMigrationData = data;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            DiagramUtils.setPrototype((Diagram)this.myDiagram, (ViewPrototype)this.myMigrationData.getPrototype());
            DiagramUtils.setOwner((Diagram)this.myDiagram, (EObject)this.myDiagram.getElement());
            this.myDiagram.setType(this.myMigrationData.getNewType());
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

