/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.RobotML;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataFlowDirectionKind implements Enumerator
{
    IN(0, "in", "in"),
    OUT(1, "out", "out"),
    INOUT(2, "inout", "inout");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    private static final DataFlowDirectionKind[] VALUES_ARRAY;
    public static final List<DataFlowDirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataFlowDirectionKind[]{IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataFlowDirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataFlowDirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataFlowDirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataFlowDirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataFlowDirectionKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
        }
        return null;
    }

    private DataFlowDirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

