/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.RobotML;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SynchronizationKind implements Enumerator
{
    SYNCH(0, "SYNCH", "SYNCH"),
    ASYNCH(1, "ASYNCH", "ASYNCH"),
    UNDEFINED(2, "undefined", "undefined");

    public static final int SYNCH_VALUE = 0;
    public static final int ASYNCH_VALUE = 1;
    public static final int UNDEFINED_VALUE = 2;
    private static final SynchronizationKind[] VALUES_ARRAY;
    public static final List<SynchronizationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SynchronizationKind[]{SYNCH, ASYNCH, UNDEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SynchronizationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizationKind get(int value) {
        switch (value) {
            case 0: {
                return SYNCH;
            }
            case 1: {
                return ASYNCH;
            }
            case 2: {
                return UNDEFINED;
            }
        }
        return null;
    }

    private SynchronizationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

