/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt;

import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class Utils {
    public static final String nsSep = "::";

    public static String decreaseIndent(char[] contents, int start, int end) {
        String newBlock = "";
        boolean newLine = true;
        int consume = 0;
        int i = start;
        while (i < end) {
            char c = contents[i];
            if (newLine && c == '\t') {
                consume = 1;
            }
            if (newLine && c == ' ') {
                consume = 4;
            }
            if (consume == 0) {
                newBlock = String.valueOf(newBlock) + c;
            } else {
                consume = c == ' ' ? --consume : 0;
            }
            newLine = c == '\n' || c == '\r';
            ++i;
        }
        return newBlock;
    }

    public static NamedElement getQualifiedElement(Package root, String qualifiedName) {
        NamedElement namedElement = null;
        int index = qualifiedName.indexOf(nsSep);
        if (index != -1) {
            String remainder = qualifiedName.substring(index + 2);
            namedElement = Utils.getQualifiedElement(root, remainder, qualifiedName);
        }
        if (namedElement == null) {
            namedElement = Utils.getQualifiedElement(root, qualifiedName, String.valueOf(root.getName()) + nsSep + qualifiedName);
        }
        return namedElement;
    }

    public static NamedElement getQualifiedElement(Package root, String remainingPath, String qualifiedName) {
        if (root == null) {
            return null;
        }
        if (!remainingPath.contains(nsSep)) {
            for (NamedElement candidate : root.getMembers()) {
                String name = candidate.getName();
                if (name == null || !name.equals(remainingPath) || !candidate.getQualifiedName().equals(qualifiedName)) continue;
                return candidate;
            }
        } else {
            String segment = remainingPath.split(nsSep)[0];
            String remainder = remainingPath.substring(segment.length() + 2);
            for (Element element : root.getMembers()) {
                NamedElement foundElement;
                if (!(element instanceof Package) || !((NamedElement)element).getName().equals(segment) || (foundElement = Utils.getQualifiedElement((Package)element, remainder, qualifiedName)) == null) continue;
                return foundElement;
            }
        }
        return null;
    }

    public static Package getTop(Element element) {
        while (element != null) {
            Element owner = element.getOwner();
            if (owner == null && element instanceof Package) {
                return (Package)element;
            }
            element = owner;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeGenerated(String bodyStr) {
        while (true) {
            if ((startPos = bodyStr.indexOf("the following code has been generated")) != -1) ** GOTO lbl5
            break;
lbl-1000:
            // 1 sources

            {
                --startPos;
lbl5:
                // 2 sources

                ** while (startPos > 0 && bodyStr.charAt((int)startPos) != '\r' && bodyStr.charAt((int)startPos) != '\n')
            }
lbl6:
            // 1 sources

            endPos = bodyStr.indexOf("generated code ends", startPos);
            if (endPos == -1) break;
            endPos += "generated code ends".length();
            while (endPos < bodyStr.length() && Character.isWhitespace(bodyStr.charAt(endPos))) {
                ++endPos;
            }
            bodyStr = String.valueOf(bodyStr.substring(0, startPos)) + bodyStr.substring(endPos);
        }
        return bodyStr;
    }
}

