/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.listener;

import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.texteditor.cdt.Activator;
import org.eclipse.papyrus.texteditor.cdt.listener.ModelListener;
import org.eclipse.papyrus.texteditor.cdt.modelresource.TextEditorModelSharedResource;
import org.eclipse.papyrus.texteditor.cdt.sync.SyncModelToCDT;
import org.eclipse.papyrus.texteditor.model.texteditormodel.TextEditorModel;
import org.eclipse.uml2.uml.Classifier;

public class OperationHistoryListener
implements IOperationHistoryListener {
    private static OperationHistoryListener ohl = null;

    public static void init() {
        if (ohl == null) {
            ohl = new OperationHistoryListener();
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)ohl);
        }
    }

    public void historyNotification(OperationHistoryEvent event) {
        int eventType = event.getEventType();
        if (eventType == 5 || eventType == 9 || eventType == 10) {
            BasicEList regenListCopy = new BasicEList(ModelListener.regenList);
            ModelListener.regenList.clear();
            for (Classifier cl : regenListCopy) {
                if (cl.eResource() == null) continue;
                try {
                    TextEditorModel tem;
                    ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)cl);
                    TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.exteditor.cdt.CDTEditorModelSharedResource");
                    if (model == null || (tem = model.getTextEditorModel((EObject)cl)) == null) continue;
                    SyncModelToCDT.syncModelToCDT(cl, tem.getGeneratorID());
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (NotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }
}

