/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.sync;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.C_Cpp.Array;
import org.eclipse.papyrus.C_Cpp.Const;
import org.eclipse.papyrus.C_Cpp.EStorageClass;
import org.eclipse.papyrus.C_Cpp.Include;
import org.eclipse.papyrus.C_Cpp.Ptr;
import org.eclipse.papyrus.C_Cpp.Ref;
import org.eclipse.papyrus.C_Cpp.StorageClass;
import org.eclipse.papyrus.C_Cpp.Volatile;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.codegen.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.codegen.extensionpoints.SyncInformation;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.texteditor.cdt.CommandSupport;
import org.eclipse.papyrus.texteditor.cdt.TextEditorConstants;
import org.eclipse.papyrus.texteditor.cdt.Utils;
import org.eclipse.papyrus.texteditor.cdt.listener.ModelListener;
import org.eclipse.papyrus.texteditor.cdt.sync.FindTransition;
import org.eclipse.papyrus.texteditor.cdt.sync.ParameterModifiers;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncCDTtoModel
implements Runnable {
    public static final String REGISTER = "register";
    public static final String CONST = "const";
    public static final String VOLATILE = "volatile";
    public static final String sAtParam = "@param";
    public static final String ansiCLib = "AnsiCLibrary";
    public final String c_cpp_langID = "C/C++";
    protected IEditorInput m_input;
    protected Classifier m_classifier;
    protected String m_projectName;
    protected ILangCodegen m_codegen;

    public SyncCDTtoModel(IEditorInput input, Classifier classifier, String projectName, String generatorID) {
        this.m_input = input;
        this.m_classifier = classifier;
        this.m_projectName = projectName;
        this.m_codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.CPP, (String)generatorID);
    }

    public void syncCDTtoModel() {
        CommandSupport.exec("update model from CDT", this);
    }

    @Override
    public void run() {
        block11: {
            ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
            ModelListener.syncFromEditor = true;
            if (ice instanceof ITranslationUnit) {
                ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
                IIndex index = null;
                try {
                    index = CCorePlugin.getIndexManager().getIndex(project);
                    index.acquireReadLock();
                    ITranslationUnit itu = (ITranslationUnit)ice;
                    IASTTranslationUnit ast = itu.getAST(index, 2);
                    IASTNodeSelector selector = ast.getNodeSelector(null);
                    this.examineChildren(itu, selector, (IParent)itu);
                    this.updateCppInclude(itu);
                    CUIPlugin.getDefault().getProblemMarkerManager();
                    if (itu instanceof IWorkingCopy) {
                        ((IWorkingCopy)itu).reconcile(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CModelException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    if (index != null) {
                        index.releaseReadLock();
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        System.err.println(e);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                if (index == null) break block11;
                index.releaseReadLock();
            }
        }
        ModelListener.syncFromEditor = false;
    }

    public void examineChildren(ITranslationUnit itu, IASTNodeSelector selector, IParent parent) throws CModelException {
        int position = 0;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren(itu, selector, (IParent)child);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                String name = ((IFunctionDeclaration)child).getElementName();
                IASTNode node = selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    IASTFunctionDeclarator declarator = definition.getDeclarator();
                    String unfilteredBody = SyncCDTtoModel.getBody(itu, definition);
                    SyncInformation syncInfo = null;
                    if (this.m_codegen instanceof ILangCodegen2) {
                        syncInfo = ((ILangCodegen2)this.m_codegen).getSyncInformation(name, unfilteredBody);
                    }
                    String body = Utils.removeGenerated(unfilteredBody);
                    if (syncInfo == null || !syncInfo.isGenerated) {
                        NamedElement ne = this.updateMethod(position, parent, name, body, declarator, syncInfo);
                        this.updateComment(itu, definition, ne);
                    }
                }
                ++position;
            }
            ++n2;
        }
    }

    public void updateCppInclude(ITranslationUnit itu) {
        Include include;
        String contents = new String(itu.getContents());
        int preBodyStart = contents.indexOf("// Include from CppInclude stereotype (pre-body)");
        int preBodyEnd = contents.indexOf("// End of CppInclude stereotype (pre-body)");
        String preBody = "";
        String body = "";
        if (preBodyStart != -1 && preBodyEnd > (preBodyStart += "// Include from CppInclude stereotype (pre-body)".length())) {
            preBody = contents.substring(preBodyStart, preBodyEnd).trim();
        }
        int bodyStart = contents.indexOf("// Include from CppInclude declaration (body)");
        int bodyEnd = contents.indexOf("// End of CppInclude stereotype (body)");
        if (bodyStart != -1 && bodyEnd > (bodyStart += "// Include from CppInclude declaration (body)".length() + 1)) {
            body = contents.substring(bodyStart, bodyEnd).trim();
        }
        if ((body.length() > 0 || preBody.length() > 0) && (include = (Include)StereotypeUtil.applyApp((Element)this.m_classifier, Include.class)) != null) {
            include.setPreBody(preBody);
            include.setBody(body);
        }
    }

    public NamedElement updateMethod(int position, IParent parent, String qualifiedName, String body, IASTFunctionDeclarator declarator, SyncInformation syncInfo) {
        String[] names = qualifiedName.split("::");
        String name = names[names.length - 1];
        Operation operation = null;
        Behavior behavior = null;
        if (syncInfo == null || syncInfo.behavior == null && syncInfo.createBehaviorName == null) {
            operation = this.getModelOperationFromName(name, parent, position);
            if (operation != null) {
                operation.setName(name);
            } else {
                behavior = FindTransition.findBehavior(this.m_classifier, name);
                if (behavior == null) {
                    if (this.m_classifier instanceof Class) {
                        operation = ((Class)this.m_classifier).createOwnedOperation(name, null, null);
                    } else if (this.m_classifier instanceof DataType) {
                        operation = ((DataType)this.m_classifier).createOwnedOperation(name, null, null);
                    }
                }
            }
        } else if (syncInfo.behavior != null) {
            behavior = syncInfo.behavior;
        } else if (syncInfo.createBehaviorName != null && this.m_classifier instanceof Class) {
            Class clazz = (Class)this.m_classifier;
            behavior = (OpaqueBehavior)clazz.createOwnedBehavior(syncInfo.createBehaviorName, UMLPackage.eINSTANCE.getOpaqueBehavior().eClass());
        }
        if (operation != null) {
            if (operation.getMethods().size() == 0) {
                if (this.m_classifier instanceof Class) {
                    behavior = ((Class)this.m_classifier).createOwnedBehavior(name, UMLPackage.eINSTANCE.getOpaqueBehavior());
                } else {
                    boolean cfr_ignored_0 = this.m_classifier instanceof DataType;
                }
                behavior.setSpecification((BehavioralFeature)operation);
                behavior.setIsReentrant(false);
            } else {
                behavior = (Behavior)operation.getMethods().get(0);
                if (!behavior.getName().equals(name)) {
                    behavior.setName(name);
                }
            }
        }
        if (operation != null) {
            UMLUtil.destroyElements((EList)operation.getOwnedParameters());
        }
        UMLUtil.destroyElements((EList)behavior.getOwnedParameters());
        IASTNode[] iASTNodeArray = declarator.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode declaratorChild = iASTNodeArray[n2];
            if (declaratorChild instanceof IASTParameterDeclaration) {
                Type paramType;
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)declaratorChild;
                IASTName parameterName = parameter.getDeclarator().getName();
                IASTDeclSpecifier parameterType = parameter.getDeclSpecifier();
                ParameterModifiers modifiers = new ParameterModifiers();
                String parameterTypeName = "";
                try {
                    String tokenStr;
                    IToken token = parameter.getDeclarator().getSyntax();
                    while (token != null) {
                        tokenStr = token.toString();
                        if (tokenStr.equals("*")) {
                            modifiers.isPointer = true;
                        } else if (tokenStr.equals("&")) {
                            modifiers.isRef = true;
                        } else if (tokenStr.equals("[")) {
                            while (token != null) {
                                modifiers.array = String.valueOf(modifiers.array) + token.toString();
                                token = token.getNext();
                            }
                            if (token == null) break;
                        }
                        token = token.getNext();
                    }
                    token = parameterType.getSyntax();
                    while (token != null) {
                        tokenStr = token.toString();
                        if (tokenStr.equals("*")) {
                            modifiers.isPointer = true;
                        } else if (tokenStr.equals("&")) {
                            modifiers.isRef = true;
                        } else if (tokenStr.equals(REGISTER)) {
                            modifiers.isRegister = true;
                        } else if (!tokenStr.equals(CONST) && !tokenStr.equals(VOLATILE)) {
                            if (parameterTypeName.length() > 0) {
                                parameterTypeName = String.valueOf(parameterTypeName) + " ";
                            }
                            parameterTypeName = String.valueOf(parameterTypeName) + tokenStr;
                        }
                        token = token.getNext();
                    }
                }
                catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {}
                NamedElement namedElemParamType = Utils.getQualifiedElement(Utils.getTop((Element)this.m_classifier), parameterTypeName);
                if (namedElemParamType == null) {
                    namedElemParamType = Utils.getQualifiedElement(Utils.getTop((Element)this.m_classifier), "AnsiCLibrary::" + parameterTypeName);
                }
                parameterType.isRestrict();
                Parameter umlParameter = null;
                Type type = paramType = namedElemParamType instanceof Type ? (Type)namedElemParamType : null;
                if (operation != null) {
                    umlParameter = operation.createOwnedParameter(parameterName.toString(), paramType);
                    this.applyParameterModifiers(parameterType, umlParameter, modifiers);
                }
                umlParameter = behavior.createOwnedParameter(parameterName.toString(), paramType);
                this.applyParameterModifiers(parameterType, umlParameter, modifiers);
            }
            ++n2;
        }
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            if (ob.getBodies().size() == 0) {
                ob.getLanguages().add((Object)"C/C++");
                ob.getBodies().add((Object)"");
            }
            int i = 0;
            while (i < ob.getLanguages().size()) {
                String language = (String)ob.getLanguages().get(i);
                if ((TextEditorConstants.CPP.matcher(language).matches() || "C/C++".equals(language)) && i < ob.getBodies().size()) {
                    ob.getBodies().set(i, (Object)body);
                }
                ++i;
            }
        }
        if (operation != null) {
            return operation;
        }
        return behavior;
    }

    public void applyParameterModifiers(IASTDeclSpecifier parameterType, Parameter umlParameter, ParameterModifiers modifiers) {
        Array arraySt;
        StorageClass sc;
        if (parameterType.isConst()) {
            StereotypeUtil.apply((Element)umlParameter, Const.class);
        }
        if (parameterType.isVolatile()) {
            StereotypeUtil.apply((Element)umlParameter, Volatile.class);
        }
        if (modifiers.isRegister && (sc = (StorageClass)StereotypeUtil.applyApp((Element)umlParameter, StorageClass.class)) != null) {
            sc.setStorageClass(EStorageClass.REGISTER);
        }
        if (modifiers.isPointer) {
            StereotypeUtil.apply((Element)umlParameter, Ptr.class);
        } else if (modifiers.isRef) {
            StereotypeUtil.apply((Element)umlParameter, Ref.class);
        }
        if (modifiers.array.length() > 0 && (arraySt = (Array)StereotypeUtil.applyApp((Element)umlParameter, Array.class)) != null && !modifiers.array.equals("[]") && !modifiers.array.equals("[ ]")) {
            arraySt.setDefinition(modifiers.array);
        }
    }

    public Operation getModelOperationFromName(String name, IParent parent, int position) {
        Operation operation = this.m_classifier.getOperation(name, null, null);
        if (operation == null && position < this.m_classifier.getOperations().size()) {
            operation = (Operation)this.m_classifier.getOperations().get(position);
            String modelName = operation.getName();
            try {
                ICElement[] iCElementArray = parent.getChildren();
                int n = iCElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cdtName;
                    ICElement child = iCElementArray[n2];
                    if (child instanceof IMethodDeclaration && (cdtName = ((IMethodDeclaration)child).getElementName()).equals(modelName)) {
                        operation = null;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {}
        }
        return operation;
    }

    public static String getBody(ITranslationUnit itu, IASTFunctionDefinition definition) {
        IASTStatement body = definition.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement bodyComp = (IASTCompoundStatement)body;
            IASTFileLocation bodyLoc = bodyComp.getFileLocation();
            int start = bodyLoc.getNodeOffset();
            int end = start + bodyLoc.getNodeLength();
            char[] contents = itu.getContents();
            return Utils.decreaseIndent(contents, start + 2, end - 2);
        }
        return "";
    }

    public void updateComment(ITranslationUnit itu, IASTFunctionDefinition definition, NamedElement ne) {
        int start;
        IASTFileLocation bodyLoc = definition.getFileLocation();
        int end = start = bodyLoc.getNodeOffset() - 1;
        char[] contents = itu.getContents();
        String comment = "";
        while (start > 0) {
            if (contents[start] == '/' && contents[start + 1] == '*') {
                int i = start += "/**".length();
                while (i < end) {
                    comment = String.valueOf(comment) + contents[i];
                    ++i;
                }
                comment = comment.replace("\n * ", "\n").replace("*/", "").trim();
                break;
            }
            --start;
        }
        if (comment.length() > 0) {
            Comment commentUML;
            int atParam = comment.indexOf(sAtParam);
            String commentMethodOnly = atParam != -1 ? comment.substring(0, atParam).trim() : comment;
            EList commentsUML = ne.getOwnedComments();
            if (commentsUML.size() == 0) {
                commentUML = ne.createOwnedComment();
                commentUML.getAnnotatedElements().add((Object)commentUML);
            } else {
                commentUML = (Comment)commentsUML.get(0);
            }
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = comment.indexOf(sAtParam, atParam + 1)) != -1 ? comment.substring(currentAtParam, atParam) : comment.substring(currentAtParam);
                int atParamName = sAtParam.length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = null;
                if (ne instanceof BehavioralFeature) {
                    parameter = ((BehavioralFeature)ne).getOwnedParameter(parameterName, null, false, false);
                } else if (ne instanceof Behavior) {
                    parameter = ((Behavior)ne).getOwnedParameter(parameterName, null, false, false);
                }
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = String.valueOf(commentMethodOnly) + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            commentUML.setBody(commentMethodOnly);
        }
    }

    public ILangCodegen getCodeGen() {
        return this.m_codegen;
    }
}

