/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.sync;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.codegen.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.codegen.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.texteditor.cdt.TextEditorConstants;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;

public class SyncModelToCDT {
    private static final String CPP_SUFFIX = "cpp";
    public static boolean syncFromEditor;

    public static IFile syncModelToCDT(Classifier classifier, String generatorID) {
        if (classifier == null || classifier.eResource() == null) {
            return null;
        }
        ILangCodegen codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.CPP, (String)generatorID);
        IProject modelProject = codegen.getTargetProject((PackageableElement)classifier, false);
        if (modelProject == null) {
            return null;
        }
        Object srcPkg = null;
        IFile cppFile = null;
        try {
            String suffix;
            codegen.generateCode(modelProject, (PackageableElement)classifier, null);
            suffix = codegen instanceof ILangCodegen2 ? (suffix = ((ILangCodegen2)codegen).getSuffix(ILangCodegen.FILE_KIND.BODY)) : CPP_SUFFIX;
            cppFile = modelProject.getFile((IPath)new Path(String.valueOf(codegen.getFileName(modelProject, (NamedElement)classifier)) + "." + suffix));
        }
        finally {
            try {
                if (srcPkg != null) {
                    srcPkg.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return cppFile;
    }
}

