/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.training.library.profile.library;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BookCategory implements Enumerator
{
    MYSTERY(0, "Mystery", "Mystery"),
    SCIENCE_FICTION(1, "ScienceFiction", "ScienceFiction"),
    BIOGRAPHY(2, "Biography", "Biography");

    public static final int MYSTERY_VALUE = 0;
    public static final int SCIENCE_FICTION_VALUE = 1;
    public static final int BIOGRAPHY_VALUE = 2;
    private static final BookCategory[] VALUES_ARRAY;
    public static final List<BookCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BookCategory[]{MYSTERY, SCIENCE_FICTION, BIOGRAPHY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BookCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BookCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BookCategory get(int value) {
        switch (value) {
            case 0: {
                return MYSTERY;
            }
            case 1: {
                return SCIENCE_FICTION;
            }
            case 2: {
                return BIOGRAPHY;
            }
        }
        return null;
    }

    private BookCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

