/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.merge.manual;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.NamedElement;

public class MergeActionDialog
extends TitleAreaDialog {
    protected NamedElement modelElement;
    protected final int WIDTH = 590;
    protected final int HEIGHT = 280;
    private List<Button> checkboxes;
    private int returnCode = 0;
    private final String REBASE_MSG = "Abandon the modifications you previously saved for this element";
    private final String MERGE_MSG = "Merge your ongoing modifications with the current state of this element [under construction]";
    private final String RECONCILE_MSG = "Try to automatically reconcile your ongoing modifications with the current state of this element (risky)";
    public static final int REBASE = 0;
    public static final int MERGE = 1;
    public static final int RECONCILE = 2;

    public MergeActionDialog(Shell parent, NamedElement modelElement) {
        super(parent);
        this.modelElement = modelElement;
        this.checkboxes = new ArrayList<Button>();
    }

    public void create() {
        super.create();
        this.setTitle("Warning");
        String value = "You have ongoing changes this model element: ";
        value = String.valueOf(value) + (this.modelElement.getName() == null ? "<unknown>" : this.modelElement.getName());
        value = String.valueOf(value) + " (" + this.modelElement.eClass().getInstanceTypeName() + ")";
        this.setMessage(value, 2);
        this.getShell().setText("Potential conflict(s) detected");
        this.getShell().setSize(590, 280);
        Rectangle parentShellBounds = this.getParentShell().getBounds();
        this.getShell().setLocation((parentShellBounds.width - 590) / 2 + parentShellBounds.x, (parentShellBounds.height - 280) / 2 + parentShellBounds.y);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(4, 4, true, true);
        container.setLayoutData((Object)data);
        container.setLayout((Layout)layout);
        this.createActionGroup(container);
        return area;
    }

    private void createActionGroup(Composite parent) {
        Group actionsGroup = new Group(parent, 0);
        actionsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 12;
        actionsGroup.setLayout((Layout)layout);
        this.checkboxes.add(this.createAction((Composite)actionsGroup, true, "Abandon the modifications you previously saved for this element"));
        Button merge = this.createAction((Composite)actionsGroup, false, "Merge your ongoing modifications with the current state of this element [under construction]");
        merge.setEnabled(false);
        this.checkboxes.add(merge);
        this.checkboxes.add(this.createAction((Composite)actionsGroup, false, "Try to automatically reconcile your ongoing modifications with the current state of this element (risky)"));
        this.returnCode = 0;
    }

    private Button createAction(Composite parent, boolean checked, String message) {
        Button checkbox = new Button(parent, 32);
        checkbox.setSelection(checked);
        checkbox.setText(message);
        checkbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        return checkbox;
    }

    public int getReturnCode() {
        if (super.getReturnCode() != 0) {
            this.returnCode = super.getReturnCode();
        }
        return this.returnCode;
    }

    private class CheckboxSelectionListener
    extends SelectionAdapter {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            for (Button checkbox : MergeActionDialog.this.checkboxes) {
                if (checkbox == e.getSource()) {
                    checkbox.setSelection(true);
                    if (checkbox.getText().equals("Abandon the modifications you previously saved for this element")) {
                        MergeActionDialog.this.returnCode = 0;
                        continue;
                    }
                    if (checkbox.getText().equals("Merge your ongoing modifications with the current state of this element [under construction]")) {
                        MergeActionDialog.this.returnCode = 1;
                        continue;
                    }
                    MergeActionDialog.this.returnCode = 2;
                    continue;
                }
                checkbox.setSelection(false);
            }
        }
    }
}

