/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.representation.compare;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.compare.IAdvancedDifference;
import org.eclipse.papyrus.uml.alf.text.representation.compare.RegionDifference;
import org.eclipse.papyrus.uml.alf.text.representation.compare.TokenDifference;
import org.eclipse.swt.graphics.Point;

public class LineDifference
extends RegionDifference
implements IAdvancedDifference {
    public LineDifference(RangeDifference d, AlfTextualRepresentation leftR, AlfTextualRepresentation rightR, IRangeComparator leftC, IRangeComparator rightC) {
        super(d, leftR, rightR, leftC, rightC);
    }

    @Override
    public String getLeftState() {
        Point position = this.getLeftFragmentPosition();
        return this.leftR.getContent().substring(position.x, position.y);
    }

    @Override
    public String getRightState() {
        Point position = this.getRightFragmentPosition();
        return this.rightR.getContent().substring(position.x, position.y);
    }

    @Override
    public Point getLeftFragmentPosition() {
        String[] leftLines = this.leftR.getContent().split("\n");
        int startIndex = 0;
        int i = 0;
        while (i < this.leftStart) {
            startIndex += leftLines[i].length() + 1;
            ++i;
        }
        int endIndex = startIndex;
        int i2 = this.leftStart;
        while (i2 < this.leftEnd()) {
            endIndex = this.leftEnd() == leftLines.length ? (endIndex += leftLines[i2].length()) : (endIndex += leftLines[i2].length() + 1);
            ++i2;
        }
        return new Point(startIndex, endIndex);
    }

    @Override
    public Point getRightFragmentPosition() {
        String[] rightLines = this.rightR.getContent().split("\n");
        int startIndex = 0;
        int i = 0;
        while (i < this.rightStart) {
            startIndex += rightLines[i].length() + 1;
            ++i;
        }
        int endIndex = startIndex;
        int i2 = this.rightStart;
        while (i2 < this.rightEnd()) {
            endIndex = this.rightEnd() == rightLines.length ? (endIndex += rightLines[i2].length()) : (endIndex += rightLines[i2].length() + 1);
            ++i2;
        }
        return new Point(startIndex, endIndex);
    }

    public List<TokenDifference> getChildren() {
        TokenComparator leftTokenComparator = new TokenComparator(this.getLeftState());
        TokenComparator rightTokenComparator = new TokenComparator(this.getRightState());
        AlfTextualRepresentation leftRepresentation = new AlfTextualRepresentation(null);
        leftRepresentation.setText(this.getLeftState());
        AlfTextualRepresentation rightRepresentation = new AlfTextualRepresentation(null);
        leftRepresentation.setText(this.getRightState());
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftTokenComparator, (IRangeComparator)rightTokenComparator);
        ArrayList<TokenDifference> tokenDifferences = new ArrayList<TokenDifference>();
        RangeDifference[] rangeDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference difference = rangeDifferenceArray[n2];
            tokenDifferences.add(new TokenDifference(difference, leftRepresentation, rightRepresentation, (IRangeComparator)leftTokenComparator, (IRangeComparator)rightTokenComparator));
            ++n2;
        }
        return tokenDifferences;
    }
}

