/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.representation.compare;

import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.compare.IAdvancedDifference;
import org.eclipse.papyrus.uml.alf.text.representation.compare.StringUtil;

public abstract class RegionDifference
extends RangeDifference
implements IAdvancedDifference {
    protected IRangeComparator leftC;
    protected IRangeComparator rightC;
    protected AlfTextualRepresentation leftR;
    protected AlfTextualRepresentation rightR;

    protected RegionDifference(RangeDifference d, AlfTextualRepresentation leftR, AlfTextualRepresentation rightR, IRangeComparator leftC, IRangeComparator rightC) {
        this(d.kind(), d.rightStart(), d.rightLength(), d.leftStart(), d.leftLength(), d.ancestorStart(), d.ancestorLength());
        this.leftC = leftC;
        this.rightC = rightC;
        this.leftR = leftR;
        this.rightR = rightR;
    }

    public RegionDifference(int kind, int rightStart, int rightLength, int leftStart, int leftLength, int ancestorStart, int ancestorLength) {
        super(kind, rightStart, rightLength, leftStart, leftLength, ancestorStart, ancestorLength);
    }

    public boolean isDeletion() {
        return !StringUtil.isNegligible(this.getLeftState()) && StringUtil.isNegligible(this.getRightState());
    }

    public boolean isAddition() {
        return StringUtil.isNegligible(this.getLeftState()) && !StringUtil.isNegligible(this.getRightState());
    }

    public boolean isChange() {
        return !StringUtil.isNegligible(this.getLeftState()) && !StringUtil.isNegligible(this.getRightState());
    }

    public String toString() {
        String serialization = "\n=======================DIFF=======================\n";
        serialization = String.valueOf(serialization) + this.getLeftState();
        serialization = String.valueOf(serialization) + "\n==================================================\n";
        serialization = String.valueOf(serialization) + this.getRightState();
        serialization = String.valueOf(serialization) + "\n=====================END DIFF=====================\n";
        return serialization;
    }
}

