/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.representation.util;

import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupUtil;
import org.eclipse.papyrus.uml.alf.text.generation.DefaultEditStringRetrievalStrategy;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.util.RepresentationParsingError;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class RepresentationParser {
    private static RepresentationParser parser;
    private BackupUtil helperBackup = BackupUtil.getInstance();
    private AlfUtil helperAlf = AlfUtil.getInstance();

    private RepresentationParser() {
    }

    public static RepresentationParser getInstance() {
        if (parser == null) {
            parser = new RepresentationParser();
        }
        return parser;
    }

    public AlfTextualRepresentation parse(NamedElement modelElement) throws RepresentationParsingError {
        if (modelElement == null) {
            throw new RepresentationParsingError("The model element for which the representation is calculated cannot be null");
        }
        AlfTextualRepresentation representation = new AlfTextualRepresentation(modelElement);
        Comment comment = this.helperAlf.getTextualRepresentationComment((Element)modelElement);
        if (comment != null) {
            Stereotype backup;
            representation.setSource(comment);
            representation.setText(comment.getBody());
            if (this.helperBackup.isBackup(comment) && (backup = this.helperBackup.getBackupStereotype((Element)modelElement)) != null) {
                representation.setEditionState(this.helperBackup.getBackupState(comment));
            }
        } else {
            representation.setText(new DefaultEditStringRetrievalStrategy().getGeneratedEditString((Element)modelElement));
        }
        return representation;
    }

    public AlfTextualRepresentation getSnapshot(NamedElement modelElement) throws RepresentationParsingError {
        if (modelElement == null) {
            throw new RepresentationParsingError("The model element for which the representation is calculated cannot be null");
        }
        AlfTextualRepresentation representation = new AlfTextualRepresentation(modelElement);
        representation.setText(new DefaultEditStringRetrievalStrategy().getGeneratedEditString((Element)modelElement));
        representation.setEditionState(new BackupState(new Timestamp(Calendar.getInstance().getTimeInMillis()), BackupState.EditionStatus.MERGED));
        return representation;
    }
}

