/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.commit;

import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.papyrus.uml.alf.transaction.commit.ChangeScenario;
import org.eclipse.papyrus.uml.alf.transaction.job.AlfCompilationJob;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;

public class CommitScenario
extends ChangeScenario {
    private boolean isCommitRequired = true;
    private StyledText view;

    public void bindView(StyledText view) {
        this.view = view;
    }

    @Override
    public void before() {
        super.before();
        BackupState editionState = new BackupState();
        editionState.status = BackupState.EditionStatus.MERGED;
        editionState.timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.userModelState.setEditionState(editionState);
        this.modelStateToBeCommitted = this.userModelState;
    }

    @Override
    public void execute(NamedElement target, String lastEditedVersion) {
        this.init(target);
        if (!this.userModelState.getContent().equals(lastEditedVersion)) {
            this.userModelState.setText(lastEditedVersion);
        }
        this.before();
        if (this.isCommitRequired) {
            AlfCompilationJob job = new AlfCompilationJob(this.modelStateToBeCommitted);
            job.setPriority(20);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    CommitScenario.this.after();
                }
            });
            job.schedule();
        } else {
            this.isCommitRequired = true;
        }
    }

    @Override
    public void after() {
        if (this.view != null && !this.view.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CommitScenario.this.view.setText(CommitScenario.this.modelStateToBeCommitted.getContent());
                }
            });
        }
    }
}

