/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.commit;

import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.util.RepresentationParser;
import org.eclipse.papyrus.uml.alf.text.representation.util.RepresentationParsingError;
import org.eclipse.papyrus.uml.alf.transaction.ActivatorTransaction;
import org.eclipse.papyrus.uml.alf.transaction.commit.IScenario;
import org.eclipse.uml2.uml.NamedElement;

public abstract class Scenario
implements IScenario {
    protected AlfTextualRepresentation userModelState = null;
    protected AlfTextualRepresentation currentModelState = null;

    protected void init(NamedElement target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("The model element provided to the scenario cannot be null");
        }
        try {
            this.userModelState = RepresentationParser.getInstance().parse(target);
            this.currentModelState = RepresentationParser.getInstance().getSnapshot(target);
        }
        catch (RepresentationParsingError e) {
            ActivatorTransaction.logger.error("Parsing of [" + target.getName() + "]", (Throwable)e);
        }
        catch (RuntimeException e) {
            ActivatorTransaction.logger.error("Serialization of [" + target.getName() + "] failed", (Throwable)e);
        }
    }
}

