/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.observation.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.alf.preferences.AlfIntegrationPreferencesUtil;
import org.eclipse.papyrus.uml.alf.transaction.commit.ISyncScenario;
import org.eclipse.papyrus.uml.alf.transaction.commit.ScenarioFactory;
import org.eclipse.papyrus.uml.alf.transaction.observation.listener.filter.FUMLFilter;
import org.eclipse.uml2.uml.Element;

public class FUMLElementListener
extends ResourceSetListenerImpl {
    public FUMLElementListener(TransactionalEditingDomain editingDomain) {
        this(editingDomain.getResourceSet());
    }

    protected FUMLElementListener(ResourceSet resourceSet) {
    }

    public NotificationFilter getFilter() {
        return new FUMLFilter();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (!AlfIntegrationPreferencesUtil.isAlfAutoSyncEnabled()) {
            return null;
        }
        CompoundCommand subCommands = new CompoundCommand("Synchronization");
        HashMap<Element, List<Notification>> modifications = new HashMap<Element, List<Notification>>();
        if (!event.getNotifications().isEmpty()) {
            for (Notification notification : event.getNotifications()) {
                Element target = (Element)notification.getNotifier();
                if (modifications.get(target) == null) {
                    modifications.put(target, new ArrayList());
                }
                modifications.get(target).add(notification);
            }
            ISyncScenario scenario = ScenarioFactory.getInstance().createSyncScenario();
            subCommands.append(scenario.synchronize(modifications));
        }
        return subCommands;
    }
}

