/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.observation.listener.filter;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.papyrus.uml.alf.transaction.observation.listener.filter.FUMLScopeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class FUMLFilter
extends NotificationFilter.Custom {
    public boolean matches(Notification notification) {
        Object notifier = notification.getNotifier();
        if (!this.isNotifierAllowed(notifier)) {
            return false;
        }
        Object feature = notification.getFeature();
        if (notifier != null && feature != null) {
            if (FUMLScopeUtil.isEnumeration(notifier)) {
                return this.isEnumerationFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isDataType(notifier)) {
                return this.isDatatypeFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isPackage(notifier)) {
                return this.isPackageFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isSignal(notifier)) {
                return this.isSignalFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isClass(notifier)) {
                return this.isClassFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isGeneralization(notifier)) {
                return this.isGeneralizationtFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isProperty(notifier)) {
                return this.isPropertyFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isOperation(notifier)) {
                return this.isOperationFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isReception(notifier)) {
                return this.isReceptionFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isLiteralUnlimitedNatural(notifier)) {
                return this.isLiteralUnlimitedNaturalFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isEnumerationLiteral(notifier)) {
                return this.isEnumerationLiteralFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isPackageImport(notifier)) {
                return this.isPackageImportFeatureListened((EStructuralFeature)feature);
            }
            if (FUMLScopeUtil.isElementImport(notifier)) {
                return this.isElementImportFeatureListened((EStructuralFeature)feature);
            }
        }
        return false;
    }

    private boolean isNotifierAllowed(Object notifier) {
        EObject target;
        boolean allowed = false;
        if (notifier instanceof Element && (target = (EObject)notifier).eResource() != null && target.eResource() instanceof UMLResource) {
            allowed = target.eResource().isTrackingModification();
        }
        return allowed;
    }

    private boolean isGeneralizationtFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getGeneralization_General() == feature || UMLPackage.eINSTANCE.getGeneralization_Specific() == feature;
    }

    private boolean isNamedElementFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name() == feature || UMLPackage.eINSTANCE.getNamedElement_QualifiedName() == feature || UMLPackage.eINSTANCE.getNamedElement_Namespace() == feature || UMLPackage.eINSTANCE.getNamedElement_Visibility() == feature || UMLPackage.eINSTANCE.getNamedElement_Namespace() == feature;
    }

    private boolean isTypeFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getType_Package() == feature || this.isPackageableElementFeatureListened(feature);
    }

    private boolean isNamespaceFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamespace_ElementImport() == feature || UMLPackage.eINSTANCE.getNamespace_Member() == feature || UMLPackage.eINSTANCE.getNamespace_OwnedMember() == feature || UMLPackage.eINSTANCE.getNamespace_PackageImport() == feature || this.isNamedElementFeatureListened(feature);
    }

    private boolean isPackageableElementFeatureListened(EStructuralFeature feature) {
        return this.isNamedElementFeatureListened(feature);
    }

    private boolean isPackageFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getPackage_URI() == feature || UMLPackage.eINSTANCE.getPackage_NestedPackage() == feature || UMLPackage.eINSTANCE.getPackage_NestingPackage() == feature || UMLPackage.eINSTANCE.getPackage_OwnedType() == feature || UMLPackage.eINSTANCE.getPackage_PackagedElement() == feature || this.isPackageableElementFeatureListened(feature) || this.isNamespaceFeatureListened(feature);
    }

    private boolean isClassifierFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getClassifier_IsFinalSpecialization() == feature || UMLPackage.eINSTANCE.getClassifier_IsAbstract() == feature || UMLPackage.eINSTANCE.getClassifier_Attribute() == feature || UMLPackage.eINSTANCE.getClassifier_Feature() == feature || UMLPackage.eINSTANCE.getClassifier_Generalization() == feature || this.isNamespaceFeatureListened(feature) || this.isTypeFeatureListened(feature);
    }

    private boolean isStructuredClassifierFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute() == feature || this.isClassifierFeatureListened(feature);
    }

    private boolean isEncapsulatedClassifierFeatureListened(EStructuralFeature feature) {
        return this.isStructuredClassifierFeatureListened(feature);
    }

    private boolean isBehavioredClassifierListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getBehavioredClassifier_ClassifierBehavior() == feature || UMLPackage.eINSTANCE.getBehavioredClassifier_OwnedBehavior() == feature || this.isClassifierFeatureListened(feature);
    }

    private boolean isClassFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getClass_IsActive() == feature || UMLPackage.eINSTANCE.getClass_NestedClassifier() == feature || UMLPackage.eINSTANCE.getClass_OwnedOperation() == feature || UMLPackage.eINSTANCE.getClass_OwnedReception() == feature || UMLPackage.eINSTANCE.getClass_SuperClass() == feature || this.isEncapsulatedClassifierFeatureListened(feature) || this.isBehavioredClassifierListened(feature);
    }

    private boolean isAssociationFeatureListener(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getAssociation_OwnedEnd() == feature || this.isClassifierFeatureListened(feature);
    }

    private boolean isSignalFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getSignal_OwnedAttribute() == feature || this.isClassifierFeatureListened(feature);
    }

    private boolean isDatatypeFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getDataType_OwnedAttribute() == feature || this.isClassifierFeatureListened(feature);
    }

    private boolean isEnumerationFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getEnumeration_OwnedLiteral() == feature || this.isDatatypeFeatureListened(feature);
    }

    private boolean isRedefinableElementFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getRedefinableElement_IsLeaf() == feature || UMLPackage.eINSTANCE.getRedefinableElement_RedefinedElement() == feature || UMLPackage.eINSTANCE.getRedefinableElement_RedefinitionContext() == feature || this.isNamedElementFeatureListened(feature);
    }

    private boolean isFeatureFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getFeature_IsStatic() == feature || UMLPackage.eINSTANCE.getFeature_FeaturingClassifier() == feature || this.isRedefinableElementFeatureListened(feature);
    }

    private boolean isMultiplicityElementFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered() == feature || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique() == feature || UMLPackage.eINSTANCE.getMultiplicityElement_Lower() == feature || UMLPackage.eINSTANCE.getMultiplicityElement_Upper() == feature;
    }

    private boolean isTypedElementFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getTypedElement_Type() == feature || this.isNamedElementFeatureListened(feature);
    }

    private boolean isStructuralFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly() == feature || this.isFeatureFeatureListened(feature) || this.isMultiplicityElementFeatureListened(feature) || this.isTypedElementFeatureListened(feature);
    }

    private boolean isPropertyFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getProperty_Aggregation() == feature || UMLPackage.eINSTANCE.getProperty_IsComposite() == feature || UMLPackage.eINSTANCE.getProperty_IsDerived() == feature || UMLPackage.eINSTANCE.getProperty_IsDerivedUnion() == feature || UMLPackage.eINSTANCE.getProperty_IsID() == feature || UMLPackage.eINSTANCE.getProperty_Association() == feature || UMLPackage.eINSTANCE.getProperty_Class() == feature || UMLPackage.eINSTANCE.getProperty_Datatype() == feature || UMLPackage.eINSTANCE.getProperty_Opposite() == feature || UMLPackage.eINSTANCE.getProperty_OwningAssociation() == feature || this.isStructuralFeatureListened(feature);
    }

    private boolean isValueSpecificationFeatureListened(EStructuralFeature feature) {
        return this.isTypedElementFeatureListened(feature);
    }

    private boolean isLiteralSpecificationFeatureListened(EStructuralFeature feature) {
        return this.isValueSpecificationFeatureListened(feature);
    }

    private boolean isLiteralUnlimitedNaturalFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value() == feature || this.isLiteralSpecificationFeatureListened(feature);
    }

    private boolean isBehavioralFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getBehavioralFeature_Concurrency() == feature || UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter() == feature || UMLPackage.eINSTANCE.getBehavioralFeature_Method() == feature || this.isFeatureFeatureListened(feature);
    }

    private boolean isOperationFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getOperation_IsQuery() == feature || UMLPackage.eINSTANCE.getOperation_RedefinedOperation() == feature || UMLPackage.eINSTANCE.getOperation_Type() == feature || UMLPackage.eINSTANCE.getOperation_Class() == feature || this.isBehavioralFeatureListened(feature);
    }

    private boolean isReceptionFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getReception_Signal() == feature || this.isBehavioralFeatureListened(feature);
    }

    private boolean isInstanceSpecificationFeatureListener(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getInstanceSpecification_Classifier() == feature || UMLPackage.eINSTANCE.getInstanceSpecification_Slot() == feature || this.isNamedElementFeatureListened(feature);
    }

    private boolean isEnumerationLiteralFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getEnumerationLiteral_Enumeration() == feature || this.isInstanceSpecificationFeatureListener(feature);
    }

    private boolean isPackageImportFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getPackageImport_Visibility() == feature || UMLPackage.eINSTANCE.getPackageImport_ImportedPackage() == feature || UMLPackage.eINSTANCE.getPackageImport_ImportingNamespace() == feature;
    }

    private boolean isElementImportFeatureListened(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getElementImport_ImportedElement() == feature || UMLPackage.eINSTANCE.getElementImport_ImportingNamespace() == feature || UMLPackage.eINSTANCE.getElementImport_Visibility() == feature || UMLPackage.eINSTANCE.getElementImport_Alias() == feature;
    }
}

