/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.diagram.internal.extensions.NodeChange;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;

public class GeneralizationChangesHelper {
    protected Comparison comparison;
    protected Map<Feature, NodeChange> displayedInheritedFeatureToNodeChange = new HashMap<Feature, NodeChange>();
    protected Map<Generalization, DirectedRelationshipChange> generalizationToReferenceChange = new HashMap<Generalization, DirectedRelationshipChange>();
    protected Map<Classifier, Map<Feature, List<Generalization>>> classifierAndFeatureToGeneralizationPath = new HashMap<Classifier, Map<Feature, List<Generalization>>>();
    protected List<Class> classesWithNodeForInheritedFeature_ADDED = new ArrayList<Class>();
    protected List<Class> classesWithNodeForInheritedFeature_DELETED = new ArrayList<Class>();

    public GeneralizationChangesHelper(Comparison comparison) {
        this.comparison = comparison;
        this.classifyDiffs();
    }

    protected void classifyDiffs() {
        for (Diff difference : this.comparison.getDifferences()) {
            if (difference instanceof DirectedRelationshipChange) {
                this.evaluateGeneralizationChange((DirectedRelationshipChange)difference);
                continue;
            }
            if (!(difference instanceof NodeChange)) continue;
            this.evaluateNodeForInheritedFeatureChange((NodeChange)difference);
        }
    }

    protected void evaluateGeneralizationChange(DirectedRelationshipChange difference) {
        if (difference.getDiscriminant() instanceof Generalization) {
            this.generalizationToReferenceChange.put((Generalization)difference.getDiscriminant(), difference);
        }
    }

    protected void evaluateNodeForInheritedFeatureChange(NodeChange difference) {
        Feature feature = null;
        View view = null;
        if (difference.getView() != null && difference.getView() instanceof View) {
            view = (View)difference.getView();
            EObject semanticElement = view.getElement();
            if (semanticElement == null || !(semanticElement instanceof Feature)) {
                return;
            }
            feature = (Feature)semanticElement;
        }
        Class class_ = null;
        EObject viewContainer = view.eContainer();
        while (viewContainer != null && class_ == null) {
            EObject semanticElement;
            if (viewContainer instanceof View && (semanticElement = ((View)viewContainer).getElement()) != null && semanticElement instanceof Class) {
                class_ = (Class)semanticElement;
            }
            viewContainer = viewContainer.eContainer();
        }
        if (class_ == null) {
            return;
        }
        if (class_.getInheritedMembers().contains(feature)) {
            if (difference.getKind() == DifferenceKind.ADD) {
                if (!this.classesWithNodeForInheritedFeature_ADDED.contains(class_)) {
                    this.classesWithNodeForInheritedFeature_ADDED.add(class_);
                }
            } else if (difference.getKind() == DifferenceKind.DELETE && !this.classesWithNodeForInheritedFeature_DELETED.contains(class_)) {
                this.classesWithNodeForInheritedFeature_DELETED.add(class_);
            }
            List<Generalization> path = this.computeGeneralizationPath((Classifier)class_, feature);
            this.insertGeneralizationPath((Classifier)class_, feature, path);
            this.displayedInheritedFeatureToNodeChange.put(feature, difference);
        }
    }

    public List<Class> getClassesWithInheritedPropertyNode(DifferenceKind kind) {
        if (kind == DifferenceKind.ADD) {
            return this.classesWithNodeForInheritedFeature_ADDED;
        }
        if (kind == DifferenceKind.DELETE) {
            return this.classesWithNodeForInheritedFeature_DELETED;
        }
        return new ArrayList<Class>();
    }

    public List<Generalization> getGeneralizationPath(Classifier classifier, Feature inherited) {
        List<Object> path = null;
        Map<Feature, List<Generalization>> inheritedFeatureToPath = this.classifierAndFeatureToGeneralizationPath.get(classifier);
        if (inheritedFeatureToPath != null) {
            path = inheritedFeatureToPath.get(inherited);
        }
        return path != null ? path : new ArrayList();
    }

    public Set<Feature> getInheritedFeaturesWithNodeChange(Classifier classifier) {
        Set<Feature> inheritedFeatures = null;
        Map<Feature, List<Generalization>> inheritedFeatureToPath = this.classifierAndFeatureToGeneralizationPath.get(classifier);
        if (inheritedFeatureToPath != null) {
            inheritedFeatures = inheritedFeatureToPath.keySet();
        }
        if (inheritedFeatures == null) {
            inheritedFeatures = new HashSet<Feature>();
        }
        return inheritedFeatures;
    }

    protected List<Generalization> computeGeneralizationPath(Classifier classifier, Feature inherited) {
        Classifier featuringClassifier = (Classifier)inherited.getFeaturingClassifiers().get(0);
        Generalization match = null;
        int i = 0;
        while (i < classifier.getGeneralizations().size() && match == null) {
            Generalization generalization = (Generalization)classifier.getGeneralizations().get(i);
            if (generalization.getGeneral() == featuringClassifier) {
                match = generalization;
            }
            ++i;
        }
        ArrayList<Generalization> path = new ArrayList<Generalization>();
        if (match == null) {
            int i2 = 0;
            while (i2 < classifier.getGeneralizations().size() && path.size() == 0) {
                Generalization generalization = (Generalization)classifier.getGeneralizations().get(i2);
                Classifier general = generalization.getGeneral();
                List<Generalization> remaining = this.computeGeneralizationPath(general, inherited);
                if (remaining.size() != 0) {
                    path.add(generalization);
                    path.addAll(remaining);
                }
                ++i2;
            }
        } else {
            path = new ArrayList();
            path.add(match);
        }
        return path;
    }

    protected void insertGeneralizationPath(Classifier classifier, Feature inherited, List<Generalization> path) {
        Map<Feature, List<Generalization>> inheritedFeatureToGeneralizationPath = this.classifierAndFeatureToGeneralizationPath.get(classifier);
        if (inheritedFeatureToGeneralizationPath == null) {
            inheritedFeatureToGeneralizationPath = new HashMap<Feature, List<Generalization>>();
        }
        inheritedFeatureToGeneralizationPath.put(inherited, path);
        this.classifierAndFeatureToGeneralizationPath.put(classifier, inheritedFeatureToGeneralizationPath);
    }

    public DirectedRelationshipChange getGeneralizationChange(Generalization generalization) {
        return this.generalizationToReferenceChange.get(generalization);
    }

    public NodeChange getFeatureNodeChange(Feature feature) {
        return this.displayedInheritedFeatureToNodeChange.get(feature);
    }
}

