/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.linklf.policy.graphicalnode;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.gmf.tooling.runtime.linklf.policies.LinksLFGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectFlow;

public class LinksLFObjectFlowWithPinsCreationEditPolicies
extends LinksLFGraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, (CreateViewRequest.ViewDescriptor)req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        if (LinksLFObjectFlowWithPinsCreationEditPolicies.getObjectFlowHint().equals(req.getConnectionViewDescriptor().getSemanticHint())) {
            sceCommand.setNewSourceAdaptor(this.getObjectFlowSourceViewAdapter(request));
        } else {
            sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        }
        ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    private static String getObjectFlowHint() {
        IHintedType objectFlowType = (IHintedType)UMLElementTypes.ObjectFlow_4003;
        return objectFlowType.getSemanticHint();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)request);
        Iterator commandItr = cc.iterator();
        commandItr.next();
        SetConnectionEndsCommand sceCommand = (SetConnectionEndsCommand)commandItr.next();
        if (request instanceof CreateConnectionViewRequest && LinksLFObjectFlowWithPinsCreationEditPolicies.getObjectFlowHint().equals(((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            sceCommand.setNewTargetAdaptor(this.getObjectFlowTargetViewAdapter(request));
        } else {
            sceCommand.setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)targetEP).getNotationView()));
        }
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        this.setViewAdapter(sceCommand.getEdgeAdaptor());
        INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        PointList pointList = new PointList();
        if (request.getLocation() == null) {
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
        } else {
            pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
            pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
        }
        SetConnectionBendpointsCommand sbbCommand = (SetConnectionBendpointsCommand)commandItr.next();
        sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
        return request.getStartCommand();
    }

    private IAdaptable getObjectFlowSourceViewAdapter(CreateConnectionRequest request) {
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter != null && adapter.isAssignableFrom(ShapeImpl.class)) {
                    return LinksLFObjectFlowWithPinsCreationEditPolicies.this.getObjectFlowExtremityView(true);
                }
                return null;
            }
        };
    }

    private IAdaptable getObjectFlowTargetViewAdapter(CreateConnectionRequest request) {
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter != null && adapter.isAssignableFrom(ShapeImpl.class)) {
                    return LinksLFObjectFlowWithPinsCreationEditPolicies.this.getObjectFlowExtremityView(false);
                }
                return null;
            }
        };
    }

    protected View getObjectFlowExtremityView(boolean isStartEnd) {
        EObject objectFlow;
        Object objectFlowView = this.getViewAdapter().getAdapter(Connector.class);
        if (objectFlowView instanceof Connector && (objectFlow = ((Connector)objectFlowView).getElement()) instanceof ObjectFlow) {
            ActivityNode actNode = null;
            actNode = isStartEnd ? ((ObjectFlow)objectFlow).getSource() : ((ObjectFlow)objectFlow).getTarget();
            if (actNode != null) {
                View view;
                if (this.getHost().getModel() instanceof View && actNode.equals((view = (View)this.getHost().getModel()).getElement())) {
                    return view;
                }
                EditPolicy policy = this.getHost().getEditPolicy((Object)"Canonical");
                if (policy instanceof CanonicalEditPolicy) {
                    CanonicalEditPolicy canonical = (CanonicalEditPolicy)policy;
                    if (!canonical.isEnabled()) {
                        canonical.setEnable(true);
                        canonical.refresh();
                        canonical.setEnable(false);
                    } else {
                        canonical.refresh();
                    }
                }
                for (Object childPart : this.getHost().getChildren()) {
                    Object containedView;
                    if (!(childPart instanceof EditPart) || !((containedView = ((EditPart)childPart).getModel()) instanceof View) || !actNode.equals(((View)containedView).getElement())) continue;
                    return (View)containedView;
                }
            }
        }
        return null;
    }
}

