/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.linklf.providers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.linklf.LinkLFShapeNodeAnchorDelegate;
import org.eclipse.gmf.tooling.runtime.linklf.editparts.LinkLFAnchorsDelegatingEditPart;
import org.eclipse.gmf.tooling.runtime.linklf.editparts.LinkLFConnectionNodeEditPart;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustBorderItemAnchorsEditPolicy;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustImplicitlyMovedLinksEditPolicy;
import org.eclipse.gmf.tooling.runtime.linklf.policies.AdjustSyntheticBendpointsEditPolicy;
import org.eclipse.papyrus.uml.diagram.linklf.policy.graphicalnode.DefaultLinksLFEditPolicy;

public class LinksLFEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider,
IExecutableExtension {
    public static final String DIAGRAM_NOTATION_CLASS = "org.eclipse.gmf.runtime.notation.Diagram(org.eclipse.gmf.runtime.notation)";
    private String myDiagramID;

    public boolean provides(IOperation op) {
        if (!(op instanceof CreateEditPoliciesOperation)) {
            return false;
        }
        CreateEditPoliciesOperation operation = (CreateEditPoliciesOperation)op;
        EditPart host = operation.getEditPart();
        if (!(host instanceof IGraphicalEditPart)) {
            return false;
        }
        View notationView = ((IGraphicalEditPart)host).getNotationView();
        if (notationView == null) {
            return false;
        }
        Diagram diagram = notationView.getDiagram();
        return this.isSupportedDiagram(diagram);
    }

    private boolean isSupportedDiagram(Diagram diagram) {
        return diagram != null && this.myDiagramID != null && this.myDiagramID.equals(diagram.getType());
    }

    public void createEditPolicies(EditPart editPart) {
        IGraphicalEditPart graphicalEP = (IGraphicalEditPart)editPart;
        if (graphicalEP instanceof LinkLFConnectionNodeEditPart) {
            this.installLinkEditPolicies((LinkLFConnectionNodeEditPart)editPart);
        } else if (editPart instanceof INodeEditPart) {
            this.installNodeEditPolicies((INodeEditPart)editPart);
        }
    }

    protected void installLinkEditPolicies(LinkLFConnectionNodeEditPart linkEP) {
        linkEP.setLinkLFEnabled(true);
    }

    protected void installNodeEditPolicies(INodeEditPart nodeEP) {
        if (nodeEP instanceof LinkLFAnchorsDelegatingEditPart) {
            LinkLFAnchorsDelegatingEditPart linklfEP = (LinkLFAnchorsDelegatingEditPart)nodeEP;
            linklfEP.setAnchorDelegate((LinkLFAnchorsDelegatingEditPart.ConnectionAnchorDelegate)new LinkLFShapeNodeAnchorDelegate(linklfEP.getNodeFigure()));
        }
        this.installGraphicalNodeEditPolicy(nodeEP);
        nodeEP.installEditPolicy((Object)AdjustSyntheticBendpointsEditPolicy.ROLE, (EditPolicy)new AdjustSyntheticBendpointsEditPolicy());
        nodeEP.installEditPolicy((Object)AdjustImplicitlyMovedLinksEditPolicy.ROLE, (EditPolicy)new AdjustImplicitlyMovedLinksEditPolicy());
        if (nodeEP instanceof IBorderItemEditPart) {
            nodeEP.installEditPolicy((Object)AdjustBorderItemAnchorsEditPolicy.ROLE, (EditPolicy)new AdjustBorderItemAnchorsEditPolicy());
        }
    }

    protected void installGraphicalNodeEditPolicy(INodeEditPart nodeEP) {
        if (nodeEP.getEditPolicy((Object)"GraphicalNodeEditPolicy") != null) {
            nodeEP.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new DefaultLinksLFEditPolicy());
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.initFromIConfig(config);
    }

    public void initFromIConfig(IConfigurationElement config) {
        IConfigurationElement[] children;
        String classAttr = config.getAttribute("class");
        if (DIAGRAM_NOTATION_CLASS.equals(classAttr)) {
            this.myDiagramID = this.getValue(config);
        }
        if ((children = config.getChildren()) != null) {
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                this.initFromIConfig(child);
                ++n2;
            }
        }
    }

    private String getValue(IConfigurationElement config) {
        IConfigurationElement[] methods = config.getChildren("method");
        if (methods == null || methods.length != 1) {
            return "";
        }
        IConfigurationElement method = methods[0];
        String value = method.getAttribute("value");
        if (value == null || value.isEmpty()) {
            return "";
        }
        return value;
    }
}

