/**
 * Copyright (c) 2014 CEA LIST.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *  CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.umldi.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.papyrus.umldi.util.UMLDIAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * 
 * @generated
 */
public class UMLDIItemProviderAdapterFactory extends UMLDIAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UMLDIItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IItemColorProvider.class);
		supportedTypes.add(IItemFontProvider.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.UmlStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UmlStyleItemProvider umlStyleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.UmlStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUmlStyleAdapter() {
		if(umlStyleItemProvider == null) {
			umlStyleItemProvider = new UmlStyleItemProvider(this);
		}
		return umlStyleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.MainLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MainLabelItemProvider mainLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.MainLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMainLabelAdapter() {
		if(mainLabelItemProvider == null) {
			mainLabelItemProvider = new MainLabelItemProvider(this);
		}
		return mainLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ClassDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ClassDiagramItemProvider classDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ClassDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createClassDiagramAdapter() {
		if(classDiagramItemProvider == null) {
			classDiagramItemProvider = new ClassDiagramItemProvider(this);
		}
		return classDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StereotypeCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StereotypeCompartmentItemProvider stereotypeCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StereotypeCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStereotypeCompartmentAdapter() {
		if(stereotypeCompartmentItemProvider == null) {
			stereotypeCompartmentItemProvider = new StereotypeCompartmentItemProvider(this);
		}
		return stereotypeCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TemplateParameterCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TemplateParameterCompartmentItemProvider templateParameterCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TemplateParameterCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterCompartmentAdapter() {
		if(templateParameterCompartmentItemProvider == null) {
			templateParameterCompartmentItemProvider = new TemplateParameterCompartmentItemProvider(this);
		}
		return templateParameterCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ListItemLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ListItemLabelItemProvider listItemLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ListItemLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createListItemLabelAdapter() {
		if(listItemLabelItemProvider == null) {
			listItemLabelItemProvider = new ListItemLabelItemProvider(this);
		}
		return listItemLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StereotypeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StereotypeLabelItemProvider stereotypeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StereotypeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStereotypeLabelAdapter() {
		if(stereotypeLabelItemProvider == null) {
			stereotypeLabelItemProvider = new StereotypeLabelItemProvider(this);
		}
		return stereotypeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.OwnedUseCaseCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected OwnedUseCaseCompartmentItemProvider ownedUseCaseCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.OwnedUseCaseCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOwnedUseCaseCompartmentAdapter() {
		if(ownedUseCaseCompartmentItemProvider == null) {
			ownedUseCaseCompartmentItemProvider = new OwnedUseCaseCompartmentItemProvider(this);
		}
		return ownedUseCaseCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.UseCaseCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UseCaseCompartmentItemProvider useCaseCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.UseCaseCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUseCaseCompartmentAdapter() {
		if(useCaseCompartmentItemProvider == null) {
			useCaseCompartmentItemProvider = new UseCaseCompartmentItemProvider(this);
		}
		return useCaseCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PackageShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PackageShapeItemProvider packageShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PackageShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPackageShapeAdapter() {
		if(packageShapeItemProvider == null) {
			packageShapeItemProvider = new PackageShapeItemProvider(this);
		}
		return packageShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PackagedElementCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PackagedElementCompartmentItemProvider packagedElementCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PackagedElementCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPackagedElementCompartmentAdapter() {
		if(packagedElementCompartmentItemProvider == null) {
			packagedElementCompartmentItemProvider = new PackagedElementCompartmentItemProvider(this);
		}
		return packagedElementCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ConstraintShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConstraintShapeItemProvider constraintShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ConstraintShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createConstraintShapeAdapter() {
		if(constraintShapeItemProvider == null) {
			constraintShapeItemProvider = new ConstraintShapeItemProvider(this);
		}
		return constraintShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AttributeCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AttributeCompartmentItemProvider attributeCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AttributeCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAttributeCompartmentAdapter() {
		if(attributeCompartmentItemProvider == null) {
			attributeCompartmentItemProvider = new AttributeCompartmentItemProvider(this);
		}
		return attributeCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.OperationCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected OperationCompartmentItemProvider operationCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.OperationCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOperationCompartmentAdapter() {
		if(operationCompartmentItemProvider == null) {
			operationCompartmentItemProvider = new OperationCompartmentItemProvider(this);
		}
		return operationCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ReceptionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ReceptionCompartmentItemProvider receptionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ReceptionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createReceptionCompartmentAdapter() {
		if(receptionCompartmentItemProvider == null) {
			receptionCompartmentItemProvider = new ReceptionCompartmentItemProvider(this);
		}
		return receptionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.LiteralCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected LiteralCompartmentItemProvider literalCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.LiteralCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createLiteralCompartmentAdapter() {
		if(literalCompartmentItemProvider == null) {
			literalCompartmentItemProvider = new LiteralCompartmentItemProvider(this);
		}
		return literalCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.EnumerationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EnumerationShapeItemProvider enumerationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.EnumerationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEnumerationShapeAdapter() {
		if(enumerationShapeItemProvider == null) {
			enumerationShapeItemProvider = new EnumerationShapeItemProvider(this);
		}
		return enumerationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.RoleLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RoleLabelItemProvider roleLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.RoleLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRoleLabelAdapter() {
		if(roleLabelItemProvider == null) {
			roleLabelItemProvider = new RoleLabelItemProvider(this);
		}
		return roleLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AssociationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AssociationEdgeItemProvider associationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AssociationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAssociationEdgeAdapter() {
		if(associationEdgeItemProvider == null) {
			associationEdgeItemProvider = new AssociationEdgeItemProvider(this);
		}
		return associationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.MultiplicityLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MultiplicityLabelItemProvider multiplicityLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.MultiplicityLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMultiplicityLabelAdapter() {
		if(multiplicityLabelItemProvider == null) {
			multiplicityLabelItemProvider = new MultiplicityLabelItemProvider(this);
		}
		return multiplicityLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PropertyEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PropertyEdgeItemProvider propertyEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PropertyEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPropertyEdgeAdapter() {
		if(propertyEdgeItemProvider == null) {
			propertyEdgeItemProvider = new PropertyEdgeItemProvider(this);
		}
		return propertyEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ConstraintLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConstraintLabelItemProvider constraintLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ConstraintLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createConstraintLabelAdapter() {
		if(constraintLabelItemProvider == null) {
			constraintLabelItemProvider = new ConstraintLabelItemProvider(this);
		}
		return constraintLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.GeneralizationSetEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GeneralizationSetEdgeItemProvider generalizationSetEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.GeneralizationSetEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createGeneralizationSetEdgeAdapter() {
		if(generalizationSetEdgeItemProvider == null) {
			generalizationSetEdgeItemProvider = new GeneralizationSetEdgeItemProvider(this);
		}
		return generalizationSetEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PowerLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PowerLabelItemProvider powerLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PowerLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPowerLabelAdapter() {
		if(powerLabelItemProvider == null) {
			powerLabelItemProvider = new PowerLabelItemProvider(this);
		}
		return powerLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ObjectNodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ObjectNodeShapeItemProvider objectNodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ObjectNodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createObjectNodeShapeAdapter() {
		if(objectNodeShapeItemProvider == null) {
			objectNodeShapeItemProvider = new ObjectNodeShapeItemProvider(this);
		}
		return objectNodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityNodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityNodeShapeItemProvider activityNodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityNodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityNodeShapeAdapter() {
		if(activityNodeShapeItemProvider == null) {
			activityNodeShapeItemProvider = new ActivityNodeShapeItemProvider(this);
		}
		return activityNodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SelectionLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SelectionLabelItemProvider selectionLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SelectionLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSelectionLabelAdapter() {
		if(selectionLabelItemProvider == null) {
			selectionLabelItemProvider = new SelectionLabelItemProvider(this);
		}
		return selectionLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ObjectFlowEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ObjectFlowEdgeItemProvider objectFlowEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ObjectFlowEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createObjectFlowEdgeAdapter() {
		if(objectFlowEdgeItemProvider == null) {
			objectFlowEdgeItemProvider = new ObjectFlowEdgeItemProvider(this);
		}
		return objectFlowEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.GuardLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GuardLabelItemProvider guardLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.GuardLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createGuardLabelAdapter() {
		if(guardLabelItemProvider == null) {
			guardLabelItemProvider = new GuardLabelItemProvider(this);
		}
		return guardLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.WeightLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected WeightLabelItemProvider weightLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.WeightLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createWeightLabelAdapter() {
		if(weightLabelItemProvider == null) {
			weightLabelItemProvider = new WeightLabelItemProvider(this);
		}
		return weightLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TransformationLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TransformationLabelItemProvider transformationLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TransformationLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTransformationLabelAdapter() {
		if(transformationLabelItemProvider == null) {
			transformationLabelItemProvider = new TransformationLabelItemProvider(this);
		}
		return transformationLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ConnectorEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConnectorEdgeItemProvider connectorEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ConnectorEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createConnectorEdgeAdapter() {
		if(connectorEdgeItemProvider == null) {
			connectorEdgeItemProvider = new ConnectorEdgeItemProvider(this);
		}
		return connectorEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InstanceSpecificationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InstanceSpecificationEdgeItemProvider instanceSpecificationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InstanceSpecificationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInstanceSpecificationEdgeAdapter() {
		if(instanceSpecificationEdgeItemProvider == null) {
			instanceSpecificationEdgeItemProvider = new InstanceSpecificationEdgeItemProvider(this);
		}
		return instanceSpecificationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DependencyEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DependencyEdgeItemProvider dependencyEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DependencyEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDependencyEdgeAdapter() {
		if(dependencyEdgeItemProvider == null) {
			dependencyEdgeItemProvider = new DependencyEdgeItemProvider(this);
		}
		return dependencyEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InstanceSpecificationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InstanceSpecificationShapeItemProvider instanceSpecificationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InstanceSpecificationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInstanceSpecificationShapeAdapter() {
		if(instanceSpecificationShapeItemProvider == null) {
			instanceSpecificationShapeItemProvider = new InstanceSpecificationShapeItemProvider(this);
		}
		return instanceSpecificationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeployedArtifactCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeployedArtifactCompartmentItemProvider deployedArtifactCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeployedArtifactCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeployedArtifactCompartmentAdapter() {
		if(deployedArtifactCompartmentItemProvider == null) {
			deployedArtifactCompartmentItemProvider = new DeployedArtifactCompartmentItemProvider(this);
		}
		return deployedArtifactCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SlotCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SlotCompartmentItemProvider slotCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SlotCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSlotCompartmentAdapter() {
		if(slotCompartmentItemProvider == null) {
			slotCompartmentItemProvider = new SlotCompartmentItemProvider(this);
		}
		return slotCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ClassShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ClassShapeItemProvider classShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ClassShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createClassShapeAdapter() {
		if(classShapeItemProvider == null) {
			classShapeItemProvider = new ClassShapeItemProvider(this);
		}
		return classShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StructureCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StructureCompartmentItemProvider structureCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StructureCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStructureCompartmentAdapter() {
		if(structureCompartmentItemProvider == null) {
			structureCompartmentItemProvider = new StructureCompartmentItemProvider(this);
		}
		return structureCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PortShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PortShapeItemProvider portShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PortShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPortShapeAdapter() {
		if(portShapeItemProvider == null) {
			portShapeItemProvider = new PortShapeItemProvider(this);
		}
		return portShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.NestedClassifierCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected NestedClassifierCompartmentItemProvider nestedClassifierCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.NestedClassifierCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createNestedClassifierCompartmentAdapter() {
		if(nestedClassifierCompartmentItemProvider == null) {
			nestedClassifierCompartmentItemProvider = new NestedClassifierCompartmentItemProvider(this);
		}
		return nestedClassifierCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.OwnedBehaviorCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected OwnedBehaviorCompartmentItemProvider ownedBehaviorCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.OwnedBehaviorCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOwnedBehaviorCompartmentAdapter() {
		if(ownedBehaviorCompartmentItemProvider == null) {
			ownedBehaviorCompartmentItemProvider = new OwnedBehaviorCompartmentItemProvider(this);
		}
		return ownedBehaviorCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InterfaceShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InterfaceShapeItemProvider interfaceShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InterfaceShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInterfaceShapeAdapter() {
		if(interfaceShapeItemProvider == null) {
			interfaceShapeItemProvider = new InterfaceShapeItemProvider(this);
		}
		return interfaceShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DataTypeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DataTypeShapeItemProvider dataTypeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DataTypeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDataTypeShapeAdapter() {
		if(dataTypeShapeItemProvider == null) {
			dataTypeShapeItemProvider = new DataTypeShapeItemProvider(this);
		}
		return dataTypeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PrimitiveTypeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PrimitiveTypeShapeItemProvider primitiveTypeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PrimitiveTypeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeShapeAdapter() {
		if(primitiveTypeShapeItemProvider == null) {
			primitiveTypeShapeItemProvider = new PrimitiveTypeShapeItemProvider(this);
		}
		return primitiveTypeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SignalShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SignalShapeItemProvider signalShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SignalShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSignalShapeAdapter() {
		if(signalShapeItemProvider == null) {
			signalShapeItemProvider = new SignalShapeItemProvider(this);
		}
		return signalShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ModelShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ModelShapeItemProvider modelShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ModelShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createModelShapeAdapter() {
		if(modelShapeItemProvider == null) {
			modelShapeItemProvider = new ModelShapeItemProvider(this);
		}
		return modelShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ContainmentEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ContainmentEdgeItemProvider containmentEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ContainmentEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createContainmentEdgeAdapter() {
		if(containmentEdgeItemProvider == null) {
			containmentEdgeItemProvider = new ContainmentEdgeItemProvider(this);
		}
		return containmentEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.GeneralizationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GeneralizationEdgeItemProvider generalizationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.GeneralizationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createGeneralizationEdgeAdapter() {
		if(generalizationEdgeItemProvider == null) {
			generalizationEdgeItemProvider = new GeneralizationEdgeItemProvider(this);
		}
		return generalizationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.RealizationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RealizationEdgeItemProvider realizationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.RealizationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRealizationEdgeAdapter() {
		if(realizationEdgeItemProvider == null) {
			realizationEdgeItemProvider = new RealizationEdgeItemProvider(this);
		}
		return realizationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AbstractionEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AbstractionEdgeItemProvider abstractionEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AbstractionEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAbstractionEdgeAdapter() {
		if(abstractionEdgeItemProvider == null) {
			abstractionEdgeItemProvider = new AbstractionEdgeItemProvider(this);
		}
		return abstractionEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InterfaceRealizationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InterfaceRealizationEdgeItemProvider interfaceRealizationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InterfaceRealizationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInterfaceRealizationEdgeAdapter() {
		if(interfaceRealizationEdgeItemProvider == null) {
			interfaceRealizationEdgeItemProvider = new InterfaceRealizationEdgeItemProvider(this);
		}
		return interfaceRealizationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.UsageEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UsageEdgeItemProvider usageEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.UsageEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUsageEdgeAdapter() {
		if(usageEdgeItemProvider == null) {
			usageEdgeItemProvider = new UsageEdgeItemProvider(this);
		}
		return usageEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ElementImportEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ElementImportEdgeItemProvider elementImportEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ElementImportEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createElementImportEdgeAdapter() {
		if(elementImportEdgeItemProvider == null) {
			elementImportEdgeItemProvider = new ElementImportEdgeItemProvider(this);
		}
		return elementImportEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PackageImportEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PackageImportEdgeItemProvider packageImportEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PackageImportEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPackageImportEdgeAdapter() {
		if(packageImportEdgeItemProvider == null) {
			packageImportEdgeItemProvider = new PackageImportEdgeItemProvider(this);
		}
		return packageImportEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PackageMergeEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PackageMergeEdgeItemProvider packageMergeEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PackageMergeEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPackageMergeEdgeAdapter() {
		if(packageMergeEdgeItemProvider == null) {
			packageMergeEdgeItemProvider = new PackageMergeEdgeItemProvider(this);
		}
		return packageMergeEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SubstitutionEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SubstitutionEdgeItemProvider substitutionEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SubstitutionEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSubstitutionEdgeAdapter() {
		if(substitutionEdgeItemProvider == null) {
			substitutionEdgeItemProvider = new SubstitutionEdgeItemProvider(this);
		}
		return substitutionEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InformationFlowEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InformationFlowEdgeItemProvider informationFlowEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InformationFlowEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInformationFlowEdgeAdapter() {
		if(informationFlowEdgeItemProvider == null) {
			informationFlowEdgeItemProvider = new InformationFlowEdgeItemProvider(this);
		}
		return informationFlowEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ConveyedLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConveyedLabelItemProvider conveyedLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ConveyedLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createConveyedLabelAdapter() {
		if(conveyedLabelItemProvider == null) {
			conveyedLabelItemProvider = new ConveyedLabelItemProvider(this);
		}
		return conveyedLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AssociationClassEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AssociationClassEdgeItemProvider associationClassEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AssociationClassEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAssociationClassEdgeAdapter() {
		if(associationClassEdgeItemProvider == null) {
			associationClassEdgeItemProvider = new AssociationClassEdgeItemProvider(this);
		}
		return associationClassEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CommentShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CommentShapeItemProvider commentShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CommentShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCommentShapeAdapter() {
		if(commentShapeItemProvider == null) {
			commentShapeItemProvider = new CommentShapeItemProvider(this);
		}
		return commentShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AttachmentEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AttachmentEdgeItemProvider attachmentEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AttachmentEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAttachmentEdgeAdapter() {
		if(attachmentEdgeItemProvider == null) {
			attachmentEdgeItemProvider = new AttachmentEdgeItemProvider(this);
		}
		return attachmentEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AssociationClassShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AssociationClassShapeItemProvider associationClassShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AssociationClassShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAssociationClassShapeAdapter() {
		if(associationClassShapeItemProvider == null) {
			associationClassShapeItemProvider = new AssociationClassShapeItemProvider(this);
		}
		return associationClassShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ComponentShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComponentShapeItemProvider componentShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ComponentShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createComponentShapeAdapter() {
		if(componentShapeItemProvider == null) {
			componentShapeItemProvider = new ComponentShapeItemProvider(this);
		}
		return componentShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InformationItemShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InformationItemShapeItemProvider informationItemShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InformationItemShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInformationItemShapeAdapter() {
		if(informationItemShapeItemProvider == null) {
			informationItemShapeItemProvider = new InformationItemShapeItemProvider(this);
		}
		return informationItemShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.RepresentationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RepresentationEdgeItemProvider representationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.RepresentationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRepresentationEdgeAdapter() {
		if(representationEdgeItemProvider == null) {
			representationEdgeItemProvider = new RepresentationEdgeItemProvider(this);
		}
		return representationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.AssociationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AssociationShapeItemProvider associationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.AssociationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAssociationShapeAdapter() {
		if(associationShapeItemProvider == null) {
			associationShapeItemProvider = new AssociationShapeItemProvider(this);
		}
		return associationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DependencyShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DependencyShapeItemProvider dependencyShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DependencyShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDependencyShapeAdapter() {
		if(dependencyShapeItemProvider == null) {
			dependencyShapeItemProvider = new DependencyShapeItemProvider(this);
		}
		return dependencyShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TimeObservationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TimeObservationShapeItemProvider timeObservationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TimeObservationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTimeObservationShapeAdapter() {
		if(timeObservationShapeItemProvider == null) {
			timeObservationShapeItemProvider = new TimeObservationShapeItemProvider(this);
		}
		return timeObservationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TimeObservationShape_TimeObservationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TimeObservationShape_TimeObservationShapeItemProvider timeObservationShape_TimeObservationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TimeObservationShape_TimeObservationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTimeObservationShape_TimeObservationShapeAdapter() {
		if(timeObservationShape_TimeObservationShapeItemProvider == null) {
			timeObservationShape_TimeObservationShapeItemProvider = new TimeObservationShape_TimeObservationShapeItemProvider(this);
		}
		return timeObservationShape_TimeObservationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DurationObservationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DurationObservationShapeItemProvider durationObservationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DurationObservationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDurationObservationShapeAdapter() {
		if(durationObservationShapeItemProvider == null) {
			durationObservationShapeItemProvider = new DurationObservationShapeItemProvider(this);
		}
		return durationObservationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PackageDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PackageDiagramItemProvider packageDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PackageDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPackageDiagramAdapter() {
		if(packageDiagramItemProvider == null) {
			packageDiagramItemProvider = new PackageDiagramItemProvider(this);
		}
		return packageDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ProfileDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProfileDiagramItemProvider profileDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ProfileDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createProfileDiagramAdapter() {
		if(profileDiagramItemProvider == null) {
			profileDiagramItemProvider = new ProfileDiagramItemProvider(this);
		}
		return profileDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CompositeStructureDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CompositeStructureDiagramItemProvider compositeStructureDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CompositeStructureDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCompositeStructureDiagramAdapter() {
		if(compositeStructureDiagramItemProvider == null) {
			compositeStructureDiagramItemProvider = new CompositeStructureDiagramItemProvider(this);
		}
		return compositeStructureDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeploymentDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeploymentDiagramItemProvider deploymentDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeploymentDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeploymentDiagramAdapter() {
		if(deploymentDiagramItemProvider == null) {
			deploymentDiagramItemProvider = new DeploymentDiagramItemProvider(this);
		}
		return deploymentDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ComponentDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComponentDiagramItemProvider componentDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ComponentDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createComponentDiagramAdapter() {
		if(componentDiagramItemProvider == null) {
			componentDiagramItemProvider = new ComponentDiagramItemProvider(this);
		}
		return componentDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ObjectDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ObjectDiagramItemProvider objectDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ObjectDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createObjectDiagramAdapter() {
		if(objectDiagramItemProvider == null) {
			objectDiagramItemProvider = new ObjectDiagramItemProvider(this);
		}
		return objectDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ProfileShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProfileShapeItemProvider profileShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ProfileShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createProfileShapeAdapter() {
		if(profileShapeItemProvider == null) {
			profileShapeItemProvider = new ProfileShapeItemProvider(this);
		}
		return profileShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ProfileApplicationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProfileApplicationEdgeItemProvider profileApplicationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ProfileApplicationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createProfileApplicationEdgeAdapter() {
		if(profileApplicationEdgeItemProvider == null) {
			profileApplicationEdgeItemProvider = new ProfileApplicationEdgeItemProvider(this);
		}
		return profileApplicationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExtensionEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExtensionEdgeItemProvider extensionEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExtensionEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExtensionEdgeAdapter() {
		if(extensionEdgeItemProvider == null) {
			extensionEdgeItemProvider = new ExtensionEdgeItemProvider(this);
		}
		return extensionEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.UseCaseDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UseCaseDiagramItemProvider useCaseDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.UseCaseDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUseCaseDiagramAdapter() {
		if(useCaseDiagramItemProvider == null) {
			useCaseDiagramItemProvider = new UseCaseDiagramItemProvider(this);
		}
		return useCaseDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ArtifactShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ArtifactShapeItemProvider artifactShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ArtifactShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createArtifactShapeAdapter() {
		if(artifactShapeItemProvider == null) {
			artifactShapeItemProvider = new ArtifactShapeItemProvider(this);
		}
		return artifactShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.NestedArtifactCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected NestedArtifactCompartmentItemProvider nestedArtifactCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.NestedArtifactCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createNestedArtifactCompartmentAdapter() {
		if(nestedArtifactCompartmentItemProvider == null) {
			nestedArtifactCompartmentItemProvider = new NestedArtifactCompartmentItemProvider(this);
		}
		return nestedArtifactCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ComponentRealizationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComponentRealizationEdgeItemProvider componentRealizationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ComponentRealizationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createComponentRealizationEdgeAdapter() {
		if(componentRealizationEdgeItemProvider == null) {
			componentRealizationEdgeItemProvider = new ComponentRealizationEdgeItemProvider(this);
		}
		return componentRealizationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ManifestationEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ManifestationEdgeItemProvider manifestationEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ManifestationEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createManifestationEdgeAdapter() {
		if(manifestationEdgeItemProvider == null) {
			manifestationEdgeItemProvider = new ManifestationEdgeItemProvider(this);
		}
		return manifestationEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PropertyShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PropertyShapeItemProvider propertyShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PropertyShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPropertyShapeAdapter() {
		if(propertyShapeItemProvider == null) {
			propertyShapeItemProvider = new PropertyShapeItemProvider(this);
		}
		return propertyShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CollaborationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CollaborationShapeItemProvider collaborationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CollaborationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCollaborationShapeAdapter() {
		if(collaborationShapeItemProvider == null) {
			collaborationShapeItemProvider = new CollaborationShapeItemProvider(this);
		}
		return collaborationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CollaborationUseShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CollaborationUseShapeItemProvider collaborationUseShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CollaborationUseShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCollaborationUseShapeAdapter() {
		if(collaborationUseShapeItemProvider == null) {
			collaborationUseShapeItemProvider = new CollaborationUseShapeItemProvider(this);
		}
		return collaborationUseShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TemplateBindingEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TemplateBindingEdgeItemProvider templateBindingEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TemplateBindingEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTemplateBindingEdgeAdapter() {
		if(templateBindingEdgeItemProvider == null) {
			templateBindingEdgeItemProvider = new TemplateBindingEdgeItemProvider(this);
		}
		return templateBindingEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StereotypeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StereotypeShapeItemProvider stereotypeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StereotypeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStereotypeShapeAdapter() {
		if(stereotypeShapeItemProvider == null) {
			stereotypeShapeItemProvider = new StereotypeShapeItemProvider(this);
		}
		return stereotypeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.NodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected NodeShapeItemProvider nodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.NodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createNodeShapeAdapter() {
		if(nodeShapeItemProvider == null) {
			nodeShapeItemProvider = new NodeShapeItemProvider(this);
		}
		return nodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.NestedNodeCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected NestedNodeCompartmentItemProvider nestedNodeCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.NestedNodeCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createNestedNodeCompartmentAdapter() {
		if(nestedNodeCompartmentItemProvider == null) {
			nestedNodeCompartmentItemProvider = new NestedNodeCompartmentItemProvider(this);
		}
		return nestedNodeCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeviceShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeviceShapeItemProvider deviceShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeviceShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeviceShapeAdapter() {
		if(deviceShapeItemProvider == null) {
			deviceShapeItemProvider = new DeviceShapeItemProvider(this);
		}
		return deviceShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExecutionEnvironmentShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExecutionEnvironmentShapeItemProvider executionEnvironmentShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExecutionEnvironmentShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExecutionEnvironmentShapeAdapter() {
		if(executionEnvironmentShapeItemProvider == null) {
			executionEnvironmentShapeItemProvider = new ExecutionEnvironmentShapeItemProvider(this);
		}
		return executionEnvironmentShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityShapeItemProvider activityShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityShapeAdapter() {
		if(activityShapeItemProvider == null) {
			activityShapeItemProvider = new ActivityShapeItemProvider(this);
		}
		return activityShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityNodeCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityNodeCompartmentItemProvider activityNodeCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityNodeCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityNodeCompartmentAdapter() {
		if(activityNodeCompartmentItemProvider == null) {
			activityNodeCompartmentItemProvider = new ActivityNodeCompartmentItemProvider(this);
		}
		return activityNodeCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ParameterCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ParameterCompartmentItemProvider parameterCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ParameterCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createParameterCompartmentAdapter() {
		if(parameterCompartmentItemProvider == null) {
			parameterCompartmentItemProvider = new ParameterCompartmentItemProvider(this);
		}
		return parameterCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PostConditionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PostConditionCompartmentItemProvider postConditionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PostConditionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPostConditionCompartmentAdapter() {
		if(postConditionCompartmentItemProvider == null) {
			postConditionCompartmentItemProvider = new PostConditionCompartmentItemProvider(this);
		}
		return postConditionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PreConditionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PreConditionCompartmentItemProvider preConditionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PreConditionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPreConditionCompartmentAdapter() {
		if(preConditionCompartmentItemProvider == null) {
			preConditionCompartmentItemProvider = new PreConditionCompartmentItemProvider(this);
		}
		return preConditionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityParameterNodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityParameterNodeShapeItemProvider activityParameterNodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityParameterNodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityParameterNodeShapeAdapter() {
		if(activityParameterNodeShapeItemProvider == null) {
			activityParameterNodeShapeItemProvider = new ActivityParameterNodeShapeItemProvider(this);
		}
		return activityParameterNodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InteractionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InteractionShapeItemProvider interactionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InteractionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInteractionShapeAdapter() {
		if(interactionShapeItemProvider == null) {
			interactionShapeItemProvider = new InteractionShapeItemProvider(this);
		}
		return interactionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InteractionFragmentShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InteractionFragmentShapeItemProvider interactionFragmentShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InteractionFragmentShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInteractionFragmentShapeAdapter() {
		if(interactionFragmentShapeItemProvider == null) {
			interactionFragmentShapeItemProvider = new InteractionFragmentShapeItemProvider(this);
		}
		return interactionFragmentShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SubfragmentCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SubfragmentCompartmentItemProvider subfragmentCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SubfragmentCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSubfragmentCompartmentAdapter() {
		if(subfragmentCompartmentItemProvider == null) {
			subfragmentCompartmentItemProvider = new SubfragmentCompartmentItemProvider(this);
		}
		return subfragmentCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.GateShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GateShapeItemProvider gateShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.GateShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createGateShapeAdapter() {
		if(gateShapeItemProvider == null) {
			gateShapeItemProvider = new GateShapeItemProvider(this);
		}
		return gateShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.OpaqueBehaviorShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected OpaqueBehaviorShapeItemProvider opaqueBehaviorShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.OpaqueBehaviorShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOpaqueBehaviorShapeAdapter() {
		if(opaqueBehaviorShapeItemProvider == null) {
			opaqueBehaviorShapeItemProvider = new OpaqueBehaviorShapeItemProvider(this);
		}
		return opaqueBehaviorShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.FunctionBehaviorShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected FunctionBehaviorShapeItemProvider functionBehaviorShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.FunctionBehaviorShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFunctionBehaviorShapeAdapter() {
		if(functionBehaviorShapeItemProvider == null) {
			functionBehaviorShapeItemProvider = new FunctionBehaviorShapeItemProvider(this);
		}
		return functionBehaviorShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StateMachineShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StateMachineShapeItemProvider stateMachineShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StateMachineShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStateMachineShapeAdapter() {
		if(stateMachineShapeItemProvider == null) {
			stateMachineShapeItemProvider = new StateMachineShapeItemProvider(this);
		}
		return stateMachineShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PseudostateShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PseudostateShapeItemProvider pseudostateShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PseudostateShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPseudostateShapeAdapter() {
		if(pseudostateShapeItemProvider == null) {
			pseudostateShapeItemProvider = new PseudostateShapeItemProvider(this);
		}
		return pseudostateShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.RegionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RegionCompartmentItemProvider regionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.RegionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRegionCompartmentAdapter() {
		if(regionCompartmentItemProvider == null) {
			regionCompartmentItemProvider = new RegionCompartmentItemProvider(this);
		}
		return regionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ProtocolStateMachineShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProtocolStateMachineShapeItemProvider protocolStateMachineShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ProtocolStateMachineShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createProtocolStateMachineShapeAdapter() {
		if(protocolStateMachineShapeItemProvider == null) {
			protocolStateMachineShapeItemProvider = new ProtocolStateMachineShapeItemProvider(this);
		}
		return protocolStateMachineShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeploymentSpecificationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeploymentSpecificationShapeItemProvider deploymentSpecificationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeploymentSpecificationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeploymentSpecificationShapeAdapter() {
		if(deploymentSpecificationShapeItemProvider == null) {
			deploymentSpecificationShapeItemProvider = new DeploymentSpecificationShapeItemProvider(this);
		}
		return deploymentSpecificationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CommunicationPathEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CommunicationPathEdgeItemProvider communicationPathEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CommunicationPathEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCommunicationPathEdgeAdapter() {
		if(communicationPathEdgeItemProvider == null) {
			communicationPathEdgeItemProvider = new CommunicationPathEdgeItemProvider(this);
		}
		return communicationPathEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeploymentEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeploymentEdgeItemProvider deploymentEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeploymentEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeploymentEdgeAdapter() {
		if(deploymentEdgeItemProvider == null) {
			deploymentEdgeItemProvider = new DeploymentEdgeItemProvider(this);
		}
		return deploymentEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActorShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActorShapeItemProvider actorShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActorShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActorShapeAdapter() {
		if(actorShapeItemProvider == null) {
			actorShapeItemProvider = new ActorShapeItemProvider(this);
		}
		return actorShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExtensionPointCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExtensionPointCompartmentItemProvider extensionPointCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExtensionPointCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExtensionPointCompartmentAdapter() {
		if(extensionPointCompartmentItemProvider == null) {
			extensionPointCompartmentItemProvider = new ExtensionPointCompartmentItemProvider(this);
		}
		return extensionPointCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.UseCaseShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UseCaseShapeItemProvider useCaseShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.UseCaseShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUseCaseShapeAdapter() {
		if(useCaseShapeItemProvider == null) {
			useCaseShapeItemProvider = new UseCaseShapeItemProvider(this);
		}
		return useCaseShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.IncludeEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IncludeEdgeItemProvider includeEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.IncludeEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createIncludeEdgeAdapter() {
		if(includeEdgeItemProvider == null) {
			includeEdgeItemProvider = new IncludeEdgeItemProvider(this);
		}
		return includeEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExtendEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExtendEdgeItemProvider extendEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExtendEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExtendEdgeAdapter() {
		if(extendEdgeItemProvider == null) {
			extendEdgeItemProvider = new ExtendEdgeItemProvider(this);
		}
		return extendEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StateMachineDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StateMachineDiagramItemProvider stateMachineDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StateMachineDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStateMachineDiagramAdapter() {
		if(stateMachineDiagramItemProvider == null) {
			stateMachineDiagramItemProvider = new StateMachineDiagramItemProvider(this);
		}
		return stateMachineDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityDiagramItemProvider activityDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityDiagramAdapter() {
		if(activityDiagramItemProvider == null) {
			activityDiagramItemProvider = new ActivityDiagramItemProvider(this);
		}
		return activityDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SequenceDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SequenceDiagramItemProvider sequenceDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SequenceDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSequenceDiagramAdapter() {
		if(sequenceDiagramItemProvider == null) {
			sequenceDiagramItemProvider = new SequenceDiagramItemProvider(this);
		}
		return sequenceDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CommunicationDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CommunicationDiagramItemProvider communicationDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CommunicationDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCommunicationDiagramAdapter() {
		if(communicationDiagramItemProvider == null) {
			communicationDiagramItemProvider = new CommunicationDiagramItemProvider(this);
		}
		return communicationDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TimingDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TimingDiagramItemProvider timingDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TimingDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTimingDiagramAdapter() {
		if(timingDiagramItemProvider == null) {
			timingDiagramItemProvider = new TimingDiagramItemProvider(this);
		}
		return timingDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InteractionOverviewDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InteractionOverviewDiagramItemProvider interactionOverviewDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InteractionOverviewDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInteractionOverviewDiagramAdapter() {
		if(interactionOverviewDiagramItemProvider == null) {
			interactionOverviewDiagramItemProvider = new InteractionOverviewDiagramItemProvider(this);
		}
		return interactionOverviewDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InternalBehaviorCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InternalBehaviorCompartmentItemProvider internalBehaviorCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InternalBehaviorCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInternalBehaviorCompartmentAdapter() {
		if(internalBehaviorCompartmentItemProvider == null) {
			internalBehaviorCompartmentItemProvider = new InternalBehaviorCompartmentItemProvider(this);
		}
		return internalBehaviorCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StateShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StateShapeItemProvider stateShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StateShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStateShapeAdapter() {
		if(stateShapeItemProvider == null) {
			stateShapeItemProvider = new StateShapeItemProvider(this);
		}
		return stateShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ConnectionPointReferenceShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ConnectionPointReferenceShapeItemProvider connectionPointReferenceShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ConnectionPointReferenceShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createConnectionPointReferenceShapeAdapter() {
		if(connectionPointReferenceShapeItemProvider == null) {
			connectionPointReferenceShapeItemProvider = new ConnectionPointReferenceShapeItemProvider(this);
		}
		return connectionPointReferenceShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InternalTransitionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InternalTransitionCompartmentItemProvider internalTransitionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InternalTransitionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInternalTransitionCompartmentAdapter() {
		if(internalTransitionCompartmentItemProvider == null) {
			internalTransitionCompartmentItemProvider = new InternalTransitionCompartmentItemProvider(this);
		}
		return internalTransitionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DeferrableTriggerCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeferrableTriggerCompartmentItemProvider deferrableTriggerCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DeferrableTriggerCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeferrableTriggerCompartmentAdapter() {
		if(deferrableTriggerCompartmentItemProvider == null) {
			deferrableTriggerCompartmentItemProvider = new DeferrableTriggerCompartmentItemProvider(this);
		}
		return deferrableTriggerCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.RegionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RegionShapeItemProvider regionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.RegionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRegionShapeAdapter() {
		if(regionShapeItemProvider == null) {
			regionShapeItemProvider = new RegionShapeItemProvider(this);
		}
		return regionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SubvertexCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SubvertexCompartmentItemProvider subvertexCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SubvertexCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSubvertexCompartmentAdapter() {
		if(subvertexCompartmentItemProvider == null) {
			subvertexCompartmentItemProvider = new SubvertexCompartmentItemProvider(this);
		}
		return subvertexCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TransitionEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TransitionEdgeItemProvider transitionEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TransitionEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTransitionEdgeAdapter() {
		if(transitionEdgeItemProvider == null) {
			transitionEdgeItemProvider = new TransitionEdgeItemProvider(this);
		}
		return transitionEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ControlFlowEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ControlFlowEdgeItemProvider controlFlowEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ControlFlowEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createControlFlowEdgeAdapter() {
		if(controlFlowEdgeItemProvider == null) {
			controlFlowEdgeItemProvider = new ControlFlowEdgeItemProvider(this);
		}
		return controlFlowEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityGroupShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityGroupShapeItemProvider activityGroupShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityGroupShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityGroupShapeAdapter() {
		if(activityGroupShapeItemProvider == null) {
			activityGroupShapeItemProvider = new ActivityGroupShapeItemProvider(this);
		}
		return activityGroupShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExceptionHandlerEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExceptionHandlerEdgeItemProvider exceptionHandlerEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExceptionHandlerEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExceptionHandlerEdgeAdapter() {
		if(exceptionHandlerEdgeItemProvider == null) {
			exceptionHandlerEdgeItemProvider = new ExceptionHandlerEdgeItemProvider(this);
		}
		return exceptionHandlerEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TypeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TypeLabelItemProvider typeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TypeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTypeLabelAdapter() {
		if(typeLabelItemProvider == null) {
			typeLabelItemProvider = new TypeLabelItemProvider(this);
		}
		return typeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.IconLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IconLabelItemProvider iconLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.IconLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createIconLabelAdapter() {
		if(iconLabelItemProvider == null) {
			iconLabelItemProvider = new IconLabelItemProvider(this);
		}
		return iconLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActionShapeItemProvider actionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActionShapeAdapter() {
		if(actionShapeItemProvider == null) {
			actionShapeItemProvider = new ActionShapeItemProvider(this);
		}
		return actionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PinShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PinShapeItemProvider pinShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PinShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPinShapeAdapter() {
		if(pinShapeItemProvider == null) {
			pinShapeItemProvider = new PinShapeItemProvider(this);
		}
		return pinShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.SubpartitionCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SubpartitionCompartmentItemProvider subpartitionCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.SubpartitionCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSubpartitionCompartmentAdapter() {
		if(subpartitionCompartmentItemProvider == null) {
			subpartitionCompartmentItemProvider = new SubpartitionCompartmentItemProvider(this);
		}
		return subpartitionCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ActivityPartitionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ActivityPartitionShapeItemProvider activityPartitionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ActivityPartitionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createActivityPartitionShapeAdapter() {
		if(activityPartitionShapeItemProvider == null) {
			activityPartitionShapeItemProvider = new ActivityPartitionShapeItemProvider(this);
		}
		return activityPartitionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StructuredActivityNodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StructuredActivityNodeShapeItemProvider structuredActivityNodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StructuredActivityNodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStructuredActivityNodeShapeAdapter() {
		if(structuredActivityNodeShapeItemProvider == null) {
			structuredActivityNodeShapeItemProvider = new StructuredActivityNodeShapeItemProvider(this);
		}
		return structuredActivityNodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExpansionRegionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExpansionRegionShapeItemProvider expansionRegionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExpansionRegionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExpansionRegionShapeAdapter() {
		if(expansionRegionShapeItemProvider == null) {
			expansionRegionShapeItemProvider = new ExpansionRegionShapeItemProvider(this);
		}
		return expansionRegionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExpansionNodeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExpansionNodeShapeItemProvider expansionNodeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExpansionNodeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExpansionNodeShapeAdapter() {
		if(expansionNodeShapeItemProvider == null) {
			expansionNodeShapeItemProvider = new ExpansionNodeShapeItemProvider(this);
		}
		return expansionNodeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.LifelineShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected LifelineShapeItemProvider lifelineShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.LifelineShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createLifelineShapeAdapter() {
		if(lifelineShapeItemProvider == null) {
			lifelineShapeItemProvider = new LifelineShapeItemProvider(this);
		}
		return lifelineShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.ExecutionSpecificationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExecutionSpecificationShapeItemProvider executionSpecificationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.ExecutionSpecificationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExecutionSpecificationShapeAdapter() {
		if(executionSpecificationShapeItemProvider == null) {
			executionSpecificationShapeItemProvider = new ExecutionSpecificationShapeItemProvider(this);
		}
		return executionSpecificationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DurationConstraintShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DurationConstraintShapeItemProvider durationConstraintShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DurationConstraintShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDurationConstraintShapeAdapter() {
		if(durationConstraintShapeItemProvider == null) {
			durationConstraintShapeItemProvider = new DurationConstraintShapeItemProvider(this);
		}
		return durationConstraintShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TimeConstraintShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TimeConstraintShapeItemProvider timeConstraintShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TimeConstraintShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTimeConstraintShapeAdapter() {
		if(timeConstraintShapeItemProvider == null) {
			timeConstraintShapeItemProvider = new TimeConstraintShapeItemProvider(this);
		}
		return timeConstraintShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.TimeExpressionShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TimeExpressionShapeItemProvider timeExpressionShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.TimeExpressionShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTimeExpressionShapeAdapter() {
		if(timeExpressionShapeItemProvider == null) {
			timeExpressionShapeItemProvider = new TimeExpressionShapeItemProvider(this);
		}
		return timeExpressionShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.DurationShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DurationShapeItemProvider durationShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.DurationShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDurationShapeAdapter() {
		if(durationShapeItemProvider == null) {
			durationShapeItemProvider = new DurationShapeItemProvider(this);
		}
		return durationShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.PathEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PathEdgeItemProvider pathEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.PathEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPathEdgeAdapter() {
		if(pathEdgeItemProvider == null) {
			pathEdgeItemProvider = new PathEdgeItemProvider(this);
		}
		return pathEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.MessageLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessageLabelItemProvider messageLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.MessageLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMessageLabelAdapter() {
		if(messageLabelItemProvider == null) {
			messageLabelItemProvider = new MessageLabelItemProvider(this);
		}
		return messageLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.StateInvariantShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StateInvariantShapeItemProvider stateInvariantShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.StateInvariantShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStateInvariantShapeAdapter() {
		if(stateInvariantShapeItemProvider == null) {
			stateInvariantShapeItemProvider = new StateInvariantShapeItemProvider(this);
		}
		return stateInvariantShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.MessageEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessageEdgeItemProvider messageEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.MessageEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMessageEdgeAdapter() {
		if(messageEdgeItemProvider == null) {
			messageEdgeItemProvider = new MessageEdgeItemProvider(this);
		}
		return messageEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.GeneralOrderingEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected GeneralOrderingEdgeItemProvider generalOrderingEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.GeneralOrderingEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createGeneralOrderingEdgeAdapter() {
		if(generalOrderingEdgeItemProvider == null) {
			generalOrderingEdgeItemProvider = new GeneralOrderingEdgeItemProvider(this);
		}
		return generalOrderingEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.CombinedFragmentShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CombinedFragmentShapeItemProvider combinedFragmentShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.CombinedFragmentShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCombinedFragmentShapeAdapter() {
		if(combinedFragmentShapeItemProvider == null) {
			combinedFragmentShapeItemProvider = new CombinedFragmentShapeItemProvider(this);
		}
		return combinedFragmentShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InteractionUseShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InteractionUseShapeItemProvider interactionUseShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InteractionUseShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInteractionUseShapeAdapter() {
		if(interactionUseShapeItemProvider == null) {
			interactionUseShapeItemProvider = new InteractionUseShapeItemProvider(this);
		}
		return interactionUseShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.umldi.InteractionOperandShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InteractionOperandShapeItemProvider interactionOperandShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.umldi.InteractionOperandShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInteractionOperandShapeAdapter() {
		if(interactionOperandShapeItemProvider == null) {
			interactionOperandShapeItemProvider = new InteractionOperandShapeItemProvider(this);
		}
		return interactionOperandShapeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if(isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if(!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}
		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);
		if(parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if(umlStyleItemProvider != null)
			umlStyleItemProvider.dispose();
		if(stereotypeLabelItemProvider != null)
			stereotypeLabelItemProvider.dispose();
		if(mainLabelItemProvider != null)
			mainLabelItemProvider.dispose();
		if(stereotypeCompartmentItemProvider != null)
			stereotypeCompartmentItemProvider.dispose();
		if(listItemLabelItemProvider != null)
			listItemLabelItemProvider.dispose();
		if(classDiagramItemProvider != null)
			classDiagramItemProvider.dispose();
		if(templateParameterCompartmentItemProvider != null)
			templateParameterCompartmentItemProvider.dispose();
		if(ownedUseCaseCompartmentItemProvider != null)
			ownedUseCaseCompartmentItemProvider.dispose();
		if(useCaseCompartmentItemProvider != null)
			useCaseCompartmentItemProvider.dispose();
		if(packageShapeItemProvider != null)
			packageShapeItemProvider.dispose();
		if(packagedElementCompartmentItemProvider != null)
			packagedElementCompartmentItemProvider.dispose();
		if(constraintShapeItemProvider != null)
			constraintShapeItemProvider.dispose();
		if(attributeCompartmentItemProvider != null)
			attributeCompartmentItemProvider.dispose();
		if(operationCompartmentItemProvider != null)
			operationCompartmentItemProvider.dispose();
		if(receptionCompartmentItemProvider != null)
			receptionCompartmentItemProvider.dispose();
		if(literalCompartmentItemProvider != null)
			literalCompartmentItemProvider.dispose();
		if(enumerationShapeItemProvider != null)
			enumerationShapeItemProvider.dispose();
		if(roleLabelItemProvider != null)
			roleLabelItemProvider.dispose();
		if(associationEdgeItemProvider != null)
			associationEdgeItemProvider.dispose();
		if(multiplicityLabelItemProvider != null)
			multiplicityLabelItemProvider.dispose();
		if(propertyEdgeItemProvider != null)
			propertyEdgeItemProvider.dispose();
		if(constraintLabelItemProvider != null)
			constraintLabelItemProvider.dispose();
		if(generalizationSetEdgeItemProvider != null)
			generalizationSetEdgeItemProvider.dispose();
		if(powerLabelItemProvider != null)
			powerLabelItemProvider.dispose();
		if(objectNodeShapeItemProvider != null)
			objectNodeShapeItemProvider.dispose();
		if(activityNodeShapeItemProvider != null)
			activityNodeShapeItemProvider.dispose();
		if(selectionLabelItemProvider != null)
			selectionLabelItemProvider.dispose();
		if(objectFlowEdgeItemProvider != null)
			objectFlowEdgeItemProvider.dispose();
		if(guardLabelItemProvider != null)
			guardLabelItemProvider.dispose();
		if(weightLabelItemProvider != null)
			weightLabelItemProvider.dispose();
		if(transformationLabelItemProvider != null)
			transformationLabelItemProvider.dispose();
		if(lifelineShapeItemProvider != null)
			lifelineShapeItemProvider.dispose();
		if(interactionFragmentShapeItemProvider != null)
			interactionFragmentShapeItemProvider.dispose();
		if(actionShapeItemProvider != null)
			actionShapeItemProvider.dispose();
		if(pinShapeItemProvider != null)
			pinShapeItemProvider.dispose();
		if(connectorEdgeItemProvider != null)
			connectorEdgeItemProvider.dispose();
		if(instanceSpecificationEdgeItemProvider != null)
			instanceSpecificationEdgeItemProvider.dispose();
		if(dependencyEdgeItemProvider != null)
			dependencyEdgeItemProvider.dispose();
		if(instanceSpecificationShapeItemProvider != null)
			instanceSpecificationShapeItemProvider.dispose();
		if(deployedArtifactCompartmentItemProvider != null)
			deployedArtifactCompartmentItemProvider.dispose();
		if(slotCompartmentItemProvider != null)
			slotCompartmentItemProvider.dispose();
		if(classShapeItemProvider != null)
			classShapeItemProvider.dispose();
		if(structureCompartmentItemProvider != null)
			structureCompartmentItemProvider.dispose();
		if(portShapeItemProvider != null)
			portShapeItemProvider.dispose();
		if(nestedClassifierCompartmentItemProvider != null)
			nestedClassifierCompartmentItemProvider.dispose();
		if(ownedBehaviorCompartmentItemProvider != null)
			ownedBehaviorCompartmentItemProvider.dispose();
		if(interfaceShapeItemProvider != null)
			interfaceShapeItemProvider.dispose();
		if(dataTypeShapeItemProvider != null)
			dataTypeShapeItemProvider.dispose();
		if(primitiveTypeShapeItemProvider != null)
			primitiveTypeShapeItemProvider.dispose();
		if(signalShapeItemProvider != null)
			signalShapeItemProvider.dispose();
		if(modelShapeItemProvider != null)
			modelShapeItemProvider.dispose();
		if(containmentEdgeItemProvider != null)
			containmentEdgeItemProvider.dispose();
		if(generalizationEdgeItemProvider != null)
			generalizationEdgeItemProvider.dispose();
		if(realizationEdgeItemProvider != null)
			realizationEdgeItemProvider.dispose();
		if(abstractionEdgeItemProvider != null)
			abstractionEdgeItemProvider.dispose();
		if(interfaceRealizationEdgeItemProvider != null)
			interfaceRealizationEdgeItemProvider.dispose();
		if(usageEdgeItemProvider != null)
			usageEdgeItemProvider.dispose();
		if(elementImportEdgeItemProvider != null)
			elementImportEdgeItemProvider.dispose();
		if(packageImportEdgeItemProvider != null)
			packageImportEdgeItemProvider.dispose();
		if(packageMergeEdgeItemProvider != null)
			packageMergeEdgeItemProvider.dispose();
		if(substitutionEdgeItemProvider != null)
			substitutionEdgeItemProvider.dispose();
		if(informationFlowEdgeItemProvider != null)
			informationFlowEdgeItemProvider.dispose();
		if(conveyedLabelItemProvider != null)
			conveyedLabelItemProvider.dispose();
		if(associationClassEdgeItemProvider != null)
			associationClassEdgeItemProvider.dispose();
		if(commentShapeItemProvider != null)
			commentShapeItemProvider.dispose();
		if(attachmentEdgeItemProvider != null)
			attachmentEdgeItemProvider.dispose();
		if(associationClassShapeItemProvider != null)
			associationClassShapeItemProvider.dispose();
		if(componentShapeItemProvider != null)
			componentShapeItemProvider.dispose();
		if(informationItemShapeItemProvider != null)
			informationItemShapeItemProvider.dispose();
		if(representationEdgeItemProvider != null)
			representationEdgeItemProvider.dispose();
		if(associationShapeItemProvider != null)
			associationShapeItemProvider.dispose();
		if(dependencyShapeItemProvider != null)
			dependencyShapeItemProvider.dispose();
		if(timeObservationShapeItemProvider != null)
			timeObservationShapeItemProvider.dispose();
		if(timeObservationShape_TimeObservationShapeItemProvider != null)
			timeObservationShape_TimeObservationShapeItemProvider.dispose();
		if(durationObservationShapeItemProvider != null)
			durationObservationShapeItemProvider.dispose();
		if(packageDiagramItemProvider != null)
			packageDiagramItemProvider.dispose();
		if(profileDiagramItemProvider != null)
			profileDiagramItemProvider.dispose();
		if(compositeStructureDiagramItemProvider != null)
			compositeStructureDiagramItemProvider.dispose();
		if(deploymentDiagramItemProvider != null)
			deploymentDiagramItemProvider.dispose();
		if(componentDiagramItemProvider != null)
			componentDiagramItemProvider.dispose();
		if(objectDiagramItemProvider != null)
			objectDiagramItemProvider.dispose();
		if(profileShapeItemProvider != null)
			profileShapeItemProvider.dispose();
		if(profileApplicationEdgeItemProvider != null)
			profileApplicationEdgeItemProvider.dispose();
		if(extensionEdgeItemProvider != null)
			extensionEdgeItemProvider.dispose();
		if(useCaseDiagramItemProvider != null)
			useCaseDiagramItemProvider.dispose();
		if(artifactShapeItemProvider != null)
			artifactShapeItemProvider.dispose();
		if(nestedArtifactCompartmentItemProvider != null)
			nestedArtifactCompartmentItemProvider.dispose();
		if(componentRealizationEdgeItemProvider != null)
			componentRealizationEdgeItemProvider.dispose();
		if(manifestationEdgeItemProvider != null)
			manifestationEdgeItemProvider.dispose();
		if(propertyShapeItemProvider != null)
			propertyShapeItemProvider.dispose();
		if(collaborationShapeItemProvider != null)
			collaborationShapeItemProvider.dispose();
		if(collaborationUseShapeItemProvider != null)
			collaborationUseShapeItemProvider.dispose();
		if(templateBindingEdgeItemProvider != null)
			templateBindingEdgeItemProvider.dispose();
		if(stereotypeShapeItemProvider != null)
			stereotypeShapeItemProvider.dispose();
		if(nodeShapeItemProvider != null)
			nodeShapeItemProvider.dispose();
		if(nestedNodeCompartmentItemProvider != null)
			nestedNodeCompartmentItemProvider.dispose();
		if(deviceShapeItemProvider != null)
			deviceShapeItemProvider.dispose();
		if(executionEnvironmentShapeItemProvider != null)
			executionEnvironmentShapeItemProvider.dispose();
		if(activityShapeItemProvider != null)
			activityShapeItemProvider.dispose();
		if(activityNodeCompartmentItemProvider != null)
			activityNodeCompartmentItemProvider.dispose();
		if(parameterCompartmentItemProvider != null)
			parameterCompartmentItemProvider.dispose();
		if(postConditionCompartmentItemProvider != null)
			postConditionCompartmentItemProvider.dispose();
		if(preConditionCompartmentItemProvider != null)
			preConditionCompartmentItemProvider.dispose();
		if(activityParameterNodeShapeItemProvider != null)
			activityParameterNodeShapeItemProvider.dispose();
		if(interactionShapeItemProvider != null)
			interactionShapeItemProvider.dispose();
		if(subfragmentCompartmentItemProvider != null)
			subfragmentCompartmentItemProvider.dispose();
		if(gateShapeItemProvider != null)
			gateShapeItemProvider.dispose();
		if(opaqueBehaviorShapeItemProvider != null)
			opaqueBehaviorShapeItemProvider.dispose();
		if(functionBehaviorShapeItemProvider != null)
			functionBehaviorShapeItemProvider.dispose();
		if(stateMachineShapeItemProvider != null)
			stateMachineShapeItemProvider.dispose();
		if(pseudostateShapeItemProvider != null)
			pseudostateShapeItemProvider.dispose();
		if(regionCompartmentItemProvider != null)
			regionCompartmentItemProvider.dispose();
		if(protocolStateMachineShapeItemProvider != null)
			protocolStateMachineShapeItemProvider.dispose();
		if(deploymentSpecificationShapeItemProvider != null)
			deploymentSpecificationShapeItemProvider.dispose();
		if(communicationPathEdgeItemProvider != null)
			communicationPathEdgeItemProvider.dispose();
		if(deploymentEdgeItemProvider != null)
			deploymentEdgeItemProvider.dispose();
		if(actorShapeItemProvider != null)
			actorShapeItemProvider.dispose();
		if(extensionPointCompartmentItemProvider != null)
			extensionPointCompartmentItemProvider.dispose();
		if(useCaseShapeItemProvider != null)
			useCaseShapeItemProvider.dispose();
		if(includeEdgeItemProvider != null)
			includeEdgeItemProvider.dispose();
		if(extendEdgeItemProvider != null)
			extendEdgeItemProvider.dispose();
		if(stateMachineDiagramItemProvider != null)
			stateMachineDiagramItemProvider.dispose();
		if(activityDiagramItemProvider != null)
			activityDiagramItemProvider.dispose();
		if(sequenceDiagramItemProvider != null)
			sequenceDiagramItemProvider.dispose();
		if(communicationDiagramItemProvider != null)
			communicationDiagramItemProvider.dispose();
		if(timingDiagramItemProvider != null)
			timingDiagramItemProvider.dispose();
		if(interactionOverviewDiagramItemProvider != null)
			interactionOverviewDiagramItemProvider.dispose();
		if(internalBehaviorCompartmentItemProvider != null)
			internalBehaviorCompartmentItemProvider.dispose();
		if(stateShapeItemProvider != null)
			stateShapeItemProvider.dispose();
		if(connectionPointReferenceShapeItemProvider != null)
			connectionPointReferenceShapeItemProvider.dispose();
		if(internalTransitionCompartmentItemProvider != null)
			internalTransitionCompartmentItemProvider.dispose();
		if(deferrableTriggerCompartmentItemProvider != null)
			deferrableTriggerCompartmentItemProvider.dispose();
		if(regionShapeItemProvider != null)
			regionShapeItemProvider.dispose();
		if(subvertexCompartmentItemProvider != null)
			subvertexCompartmentItemProvider.dispose();
		if(transitionEdgeItemProvider != null)
			transitionEdgeItemProvider.dispose();
		if(controlFlowEdgeItemProvider != null)
			controlFlowEdgeItemProvider.dispose();
		if(activityGroupShapeItemProvider != null)
			activityGroupShapeItemProvider.dispose();
		if(exceptionHandlerEdgeItemProvider != null)
			exceptionHandlerEdgeItemProvider.dispose();
		if(typeLabelItemProvider != null)
			typeLabelItemProvider.dispose();
		if(interactionUseShapeItemProvider != null)
			interactionUseShapeItemProvider.dispose();
		if(iconLabelItemProvider != null)
			iconLabelItemProvider.dispose();
		if(subpartitionCompartmentItemProvider != null)
			subpartitionCompartmentItemProvider.dispose();
		if(activityPartitionShapeItemProvider != null)
			activityPartitionShapeItemProvider.dispose();
		if(structuredActivityNodeShapeItemProvider != null)
			structuredActivityNodeShapeItemProvider.dispose();
		if(expansionRegionShapeItemProvider != null)
			expansionRegionShapeItemProvider.dispose();
		if(expansionNodeShapeItemProvider != null)
			expansionNodeShapeItemProvider.dispose();
		if(messageEdgeItemProvider != null)
			messageEdgeItemProvider.dispose();
		if(generalOrderingEdgeItemProvider != null)
			generalOrderingEdgeItemProvider.dispose();
		if(combinedFragmentShapeItemProvider != null)
			combinedFragmentShapeItemProvider.dispose();
		if(interactionOperandShapeItemProvider != null)
			interactionOperandShapeItemProvider.dispose();
		if(executionSpecificationShapeItemProvider != null)
			executionSpecificationShapeItemProvider.dispose();
		if(durationConstraintShapeItemProvider != null)
			durationConstraintShapeItemProvider.dispose();
		if(timeConstraintShapeItemProvider != null)
			timeConstraintShapeItemProvider.dispose();
		if(timeExpressionShapeItemProvider != null)
			timeExpressionShapeItemProvider.dispose();
		if(durationShapeItemProvider != null)
			durationShapeItemProvider.dispose();
		if(pathEdgeItemProvider != null)
			pathEdgeItemProvider.dispose();
		if(messageLabelItemProvider != null)
			messageLabelItemProvider.dispose();
		if(stateInvariantShapeItemProvider != null)
			stateInvariantShapeItemProvider.dispose();
	}
}
