/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umldi.presentation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.dd.presentation.DDEditor;
import org.eclipse.papyrus.dd.presentation.DDModelPage;
import org.eclipse.papyrus.umldi.presentation.UMLDIEditorPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class UMLDIModelPage
extends DDModelPage {
    public UMLDIModelPage(DDEditor editor) {
        super(editor);
    }

    public void setupActions(IToolBarManager manager) {
        super.setupActions(manager);
        Action action = new Action(UMLDIEditorPlugin.INSTANCE.getString("TransformAction.title")){

            public void run() {
                EditingDomain editingDomain = UMLDIModelPage.this.getDDEditor().getEditingDomain();
                Resource inResource = (Resource)editingDomain.getResourceSet().getResources().get(0);
                EList inObjects = inResource.getContents();
                BasicModelExtent input = new BasicModelExtent((List)inObjects);
                BasicModelExtent output = new BasicModelExtent();
                ExecutionContextImpl context = new ExecutionContextImpl();
                context.setConfigProperty("keepModeling", (Object)true);
                URI transformationURI = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.umldi2dg/transforms/UmlDiToDg.qvto");
                TransformationExecutor executor = new TransformationExecutor(transformationURI);
                ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{input, output});
                if (result.getSeverity() == 0) {
                    try {
                        List outObjects = output.getContents();
                        ResourceSetImpl outResourceSet = new ResourceSetImpl();
                        Resource outResource = outResourceSet.createResource(inResource.getURI().trimFileExtension().appendFileExtension("dg"));
                        outResource.getContents().addAll((Collection)outObjects);
                        outResource.save(Collections.emptyMap());
                    }
                    catch (IOException e) {
                        UMLDIEditorPlugin.getPlugin().log(e);
                    }
                } else {
                    IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
                    UMLDIEditorPlugin.getPlugin().getLog().log(status);
                    StatusManager.getManager().handle(status, 4);
                }
            }
        };
        action.setToolTipText(UMLDIEditorPlugin.INSTANCE.getString("TransformAction.title"));
        action.setImageDescriptor(UMLDIEditorPlugin.getImageDescriptor("Transform"));
        manager.appendToGroup("Page", (IAction)action);
    }
}

