/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umldi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompartmentLayout implements Enumerator
{
    LIST(0, "list", "list"),
    DIAGRAM(1, "diagram", "diagram");

    public static final int LIST_VALUE = 0;
    public static final int DIAGRAM_VALUE = 1;
    private static final CompartmentLayout[] VALUES_ARRAY;
    public static final List<CompartmentLayout> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompartmentLayout[]{LIST, DIAGRAM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompartmentLayout get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompartmentLayout result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompartmentLayout getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompartmentLayout result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompartmentLayout get(int value) {
        switch (value) {
            case 0: {
                return LIST;
            }
            case 1: {
                return DIAGRAM;
            }
        }
        return null;
    }

    private CompartmentLayout(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

