/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umldi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Placement implements Enumerator
{
    TOP(0, "top", "top"),
    RIGHT(1, "right", "right"),
    BOTTOM(2, "bottom", "bottom"),
    LEFT(3, "left", "left");

    public static final int TOP_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    public static final int BOTTOM_VALUE = 2;
    public static final int LEFT_VALUE = 3;
    private static final Placement[] VALUES_ARRAY;
    public static final List<Placement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Placement[]{TOP, RIGHT, BOTTOM, LEFT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Placement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Placement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Placement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Placement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Placement get(int value) {
        switch (value) {
            case 0: {
                return TOP;
            }
            case 1: {
                return RIGHT;
            }
            case 2: {
                return BOTTOM;
            }
            case 3: {
                return LEFT;
            }
        }
        return null;
    }

    private Placement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

