/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.ui.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.umlrt.custom.UMLRTElementTypesEnumerator;
import org.eclipse.papyrus.umlrt.ui.Activator;
import org.eclipse.papyrus.umlrt.ui.provider.UMLRTLabelProvider;
import org.eclipse.uml2.uml.Element;

public class UMLRTFilteredLabelProvider
extends UMLRTLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            return false;
        }
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType)) continue;
            IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
            if (matcher != null) {
                if (!((ISpecializationType)type).getMatcher().matches(semanticObject)) continue;
                return true;
            }
            Activator.log.debug("no matcher for this element type: " + type);
        }
        return false;
    }

    @Override
    public String getText(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (semanticObject == null) {
            return super.getText(element);
        }
        ISpecializationType inMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
        ISpecializationType outMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
        ISpecializationType inOutMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
        if (inMessageType != null && inMessageType.getMatcher() != null && inMessageType.getMatcher().matches(semanticObject)) {
            return "in " + super.getText(element);
        }
        if (outMessageType != null && outMessageType.getMatcher() != null && outMessageType.getMatcher().matches(semanticObject)) {
            return "out " + super.getText(element);
        }
        if (inOutMessageType != null && inOutMessageType.getMatcher() != null && inOutMessageType.getMatcher().matches(semanticObject)) {
            return "inout " + super.getText(element);
        }
        return super.getText(element);
    }
}

