/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.ui.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.umlrt.custom.UMLRTElementTypesEnumerator;
import org.eclipse.papyrus.umlrt.ui.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;

public class UMLRTLabelProvider
extends UMLFilteredLabelProvider {
    public final Map<String, String> typeIdtoIconPath = new HashMap<String, String>();
    protected static String ICON_PATH = "/icons/";
    protected static String RT_MESSAGE_IN_ICON = String.valueOf(ICON_PATH) + "rt_message_in.gif";
    protected static String RT_MESSAGE_IN_OUT_ICON = String.valueOf(ICON_PATH) + "rt_message_inout.gif";
    protected static String RT_MESSAGE_OUT_ICON = String.valueOf(ICON_PATH) + "rt_message_out.gif";
    protected static String RT_MESSAGE_UNDEFINED_ICON = String.valueOf(ICON_PATH) + "rt_message_undefined.gif";
    private static final IItemLabelProvider labelProvider = new DelegatingItemLabelProvider();

    public UMLRTLabelProvider() {
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.Capsule", String.valueOf(ICON_PATH) + "capsule.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.CapsulePart", String.valueOf(ICON_PATH) + "capsule_part.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.ProtocolContainer", String.valueOf(ICON_PATH) + "protocol_container.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.Protocol", String.valueOf(ICON_PATH) + "protocol.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.RTConnector", String.valueOf(ICON_PATH) + "rt_connector.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.RTRExcludedElement", String.valueOf(ICON_PATH) + "rt_excludedElement.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.RTMessageSet", String.valueOf(ICON_PATH) + "rt_messageset.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.RTPort", String.valueOf(ICON_PATH) + "rt_port.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.ProtocolMessageIn", RT_MESSAGE_IN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.ProtocolMessageInOut", RT_MESSAGE_IN_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.ProtocolMessageOut", RT_MESSAGE_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrus.umlrt.ProtocolMessage", RT_MESSAGE_UNDEFINED_ICON);
    }

    public Image getImage(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(semanticObject);
        if (matchingTypeMatcher == null) {
            return null;
        }
        Image image = null;
        switch (matchingTypeMatcher) {
            case "org.eclipse.papyrus.umlrt.ProtocolMessageIn": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.umlrt.ui", RT_MESSAGE_IN_ICON);
                break;
            }
            case "org.eclipse.papyrus.umlrt.ProtocolMessageOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.umlrt.ui", RT_MESSAGE_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrus.umlrt.ProtocolMessageInOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.umlrt.ui", RT_MESSAGE_IN_OUT_ICON);
                break;
            }
            default: {
                image = this.getElementImage(matchingTypeMatcher, semanticObject);
            }
        }
        return image;
    }

    public String getText(Object element) {
        return labelProvider.getText(element);
    }

    protected String getMatchingType(EObject semanticObject) {
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType) || !((ISpecializationType)type).getMatcher().matches(semanticObject)) continue;
            return type.getId();
        }
        return null;
    }

    protected Image getElementImage(String id, EObject semanticObject) {
        String iconPath = this.typeIdtoIconPath.get(id);
        if (iconPath != null) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.umlrt.ui", iconPath);
        }
        return null;
    }
}

