/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.advice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.umlrt.custom.utils.MessageUtils;
import org.eclipse.papyrus.umlrt.internals.Activator;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class MessageSetEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterEditContextCommand(GetEditContextRequest request) {
        return super.getAfterEditContextCommand(request);
    }

    protected ICommand getAfterMoveCommand(MoveRequest request) {
        Object result = null;
        CompositeCommand compositeMoveCommand = new CompositeCommand("Composite Move Command");
        Map elementsToMove = request.getElementsToMove();
        if (!elementsToMove.isEmpty()) {
            for (Object elementToMove : elementsToMove.keySet()) {
                Operation operation;
                CallEvent callEvent;
                if (!(elementToMove instanceof Operation) || (callEvent = MessageUtils.getCallEvent(operation = (Operation)elementToMove)) == null) continue;
                MoveElementsCommand command = MessageUtils.createMoveCallEventCommand(request, callEvent);
                compositeMoveCommand.add((IUndoableOperation)command);
            }
        }
        result = compositeMoveCommand.isEmpty() ? super.getAfterMoveCommand(request) : compositeMoveCommand;
        return result;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (!types.contains(umlRTMessageType)) {
                return false;
            }
            return super.approveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        if (request.getElementType().getId().equals("org.eclipse.papyrus.umlrt.ProtocolMessageIn")) {
            EObject container = request.getContainer();
            Element element = (Element)container;
            Package pack = element.getNearestPackage();
            CreateElementRequest createElementRequest = new CreateElementRequest(request.getEditingDomain(), (EObject)pack, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.CallEvent"));
        }
        return super.getAfterCreateCommand(request);
    }
}

