/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class OperationAsMessageEditHelperAdvice
extends AbstractEditHelperAdvice {
    private CallEvent callEvent;

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Operation operation = (Operation)request.getElementToConfigure();
        final String name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)"CallEvent", (Collection)operation.eContainer().eContainer().eContents());
        return new ConfigureElementCommand(request){
            private IProgressMonitor progressMonitor;
            private IAdaptable info;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.progressMonitor = progressMonitor;
                this.info = info;
                this.createCallEvent(operation, name);
                return CommandResult.newOKCommandResult((Object)operation);
            }

            private void createCallEvent(Operation operation2, String name2) throws ExecutionException {
                Package protocolContainer = operation2.getNearestPackage();
                OperationAsMessageEditHelperAdvice.this.callEvent = (CallEvent)this.createElement((Element)protocolContainer, name2, (IElementType)UMLElementTypes.CALL_EVENT, Relation.CHILD);
                OperationAsMessageEditHelperAdvice.this.callEvent.setOperation(operation2);
            }

            private EObject createElement(Element referenceElement, String name2, IElementType elementType, Relation relation) throws ExecutionException {
                if (referenceElement == null || name2 == null) {
                    throw new ExecutionException("Either the referenceElement or the name parameter is null. ");
                }
                EObject newElement = null;
                CreateElementRequest createElementRequest = new CreateElementRequest((EObject)referenceElement.getNearestPackage(), elementType);
                CreateElementCommand command = new CreateElementCommand(createElementRequest);
                command.execute(this.progressMonitor, this.info);
                newElement = command.getNewElement();
                if (newElement == null) {
                    throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
                }
                ((NamedElement)newElement).setName(name2);
                return newElement;
            }
        };
    }

    private static enum Relation {
        CHILD,
        SIBLING,
        PARENT;

    }
}

