/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.advice;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.umlrt.custom.advice.OperationAsMessageEditHelperAdvice;
import org.eclipse.papyrus.umlrt.custom.utils.MessageSetUtils;
import org.eclipse.uml2.uml.Interface;

public class OperationAsMessageOutEditHelperAdvice
extends OperationAsMessageEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            EObject container = ((CreateElementRequest)request).getContainer();
            if (!(container instanceof Interface)) {
                return false;
            }
            IElementType messageSetType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.RTMessageSet");
            if (messageSetType instanceof ISpecializationType) {
                if (!((ISpecializationType)messageSetType).getMatcher().matches(container)) {
                    return false;
                }
                if (RTMessageKind.OUT == MessageSetUtils.getMessageKind(container)) {
                    return true;
                }
            }
            return false;
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        EObject container = request.getContainer();
        if (!(container instanceof Interface)) {
            return UnexecutableCommand.INSTANCE;
        }
        IElementType messageSetType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.RTMessageSet");
        if (messageSetType instanceof ISpecializationType) {
            if (!((ISpecializationType)messageSetType).getMatcher().matches(container)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (RTMessageKind.OUT == MessageSetUtils.getMessageKind(container)) {
                return super.getBeforeCreateCommand(request);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }
}

