/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.umlrt.custom.utils.ProtocolContainerUtils;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class MessageUtils {
    public static CallEvent getCallEvent(Operation operation) {
        CallEvent result = null;
        Package nearestPackage = operation.getNearestPackage();
        if (nearestPackage != null) {
            for (Element element : nearestPackage.getOwnedElements()) {
                CallEvent callEvent;
                if (!(element instanceof CallEvent) || !(callEvent = (CallEvent)element).getOperation().equals(operation)) continue;
                result = callEvent;
                break;
            }
        }
        return result;
    }

    public static MoveElementsCommand createMoveCallEventCommand(final MoveRequest request, final CallEvent callEvent) {
        MoveElementsCommand moveElementsCommand = new MoveElementsCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject protocolContainer = ProtocolContainerUtils.getProtocolContainer(request.getTargetContainer());
                MoveRequest callEventMoveRequest = new MoveRequest(protocolContainer, (EObject)callEvent);
                MoveElementsCommand command = new MoveElementsCommand(callEventMoveRequest);
                command.execute(monitor, info);
                return super.doExecuteWithResult(monitor, info);
            }
        };
        return moveElementsCommand;
    }
}

