/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.umlrt.custom.utils.ProtocolContainerUtils;
import org.eclipse.papyrus.umlrt.internals.Activator;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class ProtocolUtils {
    public static Package getProtocolContainer(Collaboration protocol) {
        return protocol.getNearestPackage();
    }

    public static Boolean isProtocol(EObject context) {
        IElementType type = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.Protocol");
        if (!(type instanceof ISpecializationType)) {
            return false;
        }
        if (((ISpecializationType)type).getMatcher().matches(context)) {
            return true;
        }
        return false;
    }

    public static List<Operation> getRTMessages(Collaboration protocol, RTMessageKind direction, boolean showInherited) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(protocol);
        if (protocolContainer == null) {
            Activator.log.error("Impossible to get the root protocol container", null);
            return Collections.emptyList();
        }
        return ProtocolContainerUtils.getRTMessages(protocolContainer, direction, showInherited);
    }

    public static Interface getMessageSet(Collaboration editContext, RTMessageKind direction) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(editContext);
        if (protocolContainer != null) {
            return ProtocolContainerUtils.getMessageSet(protocolContainer, direction);
        }
        return null;
    }

    public static Interface getMessageSetIn(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN);
    }

    public static Interface getMessageSetOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.OUT);
    }

    public static Interface getMessageSetInOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN_OUT);
    }
}

