/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.internal.sync.statemachine;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.umlrt.custom.utils.CapsuleUtils;
import org.eclipse.papyrus.umlrt.internal.sync.UMLSyncRegistry;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class VertexSyncRegistry
extends UMLSyncRegistry<Vertex> {
    private final Map<Vertex, Vertex> redefinitions = new MapMaker().weakKeys().weakValues().makeMap();

    @Override
    public Vertex getModelOf(EObject backend) {
        Vertex result = this.redefinitions.get(backend);
        return result != null ? result : (backend instanceof Vertex ? CapsuleUtils.getSuperVertex((Vertex)backend) : null);
    }

    void setRedefinedVertex(Vertex redefiningVertex, Vertex redefinedVertex) {
        if (redefinedVertex == null) {
            this.redefinitions.remove(redefiningVertex);
        } else {
            this.redefinitions.put(redefiningVertex, redefinedVertex);
        }
    }

    boolean redefines(Vertex vertex, Vertex other) {
        Vertex superVertex;
        Vertex vertex2 = superVertex = vertex instanceof State ? CapsuleUtils.getSuperVertex(vertex) : this.redefinitions.get(vertex);
        return other == superVertex;
    }

    Command createSetRedefinedVertexCommand(Vertex redefiningVertex, Vertex redefinedVertex) {
        return redefiningVertex instanceof State ? SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)redefiningVertex, (Object)UMLPackage.Literals.STATE__REDEFINED_STATE, (Object)redefinedVertex) : new RedefinitionCommand(redefiningVertex, redefinedVertex);
    }

    private final class RedefinitionCommand
    extends AbstractCommand
    implements AbstractCommand.NonDirtying {
        private final Vertex redefiningVertex;
        private final Vertex redefinedVertex;
        private Vertex oldRedefinedVertex;

        RedefinitionCommand(Vertex redefiningVertex, Vertex redefinedVertex) {
            this.redefiningVertex = redefiningVertex;
            this.redefinedVertex = redefinedVertex;
        }

        protected boolean prepare() {
            this.oldRedefinedVertex = (Vertex)VertexSyncRegistry.this.redefinitions.get(this.redefiningVertex);
            return true;
        }

        public void execute() {
            VertexSyncRegistry.this.setRedefinedVertex(this.redefiningVertex, this.redefinedVertex);
        }

        public void undo() {
            VertexSyncRegistry.this.setRedefinedVertex(this.redefiningVertex, this.oldRedefinedVertex);
        }

        public void redo() {
            VertexSyncRegistry.this.setRedefinedVertex(this.redefiningVertex, this.redefinedVertex);
        }
    }
}

