/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValignType implements Enumerator
{
    TOP(0, "top", "top"),
    MIDDLE(1, "middle", "middle"),
    BOTTOM(2, "bottom", "bottom"),
    BASELINE(3, "baseline", "baseline");

    public static final int TOP_VALUE = 0;
    public static final int MIDDLE_VALUE = 1;
    public static final int BOTTOM_VALUE = 2;
    public static final int BASELINE_VALUE = 3;
    private static final ValignType[] VALUES_ARRAY;
    public static final List<ValignType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValignType[]{TOP, MIDDLE, BOTTOM, BASELINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValignType get(String literal) {
        ValignType[] valignTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ValignType result = valignTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ValignType getByName(String name) {
        ValignType[] valignTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ValignType result = valignTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ValignType get(int value) {
        switch (value) {
            case 0: {
                return TOP;
            }
            case 1: {
                return MIDDLE;
            }
            case 2: {
                return BOTTOM;
            }
            case 3: {
                return BASELINE;
            }
        }
        return null;
    }

    private ValignType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

