/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IBuildEditor;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEditor
extends AbstractFileEditor
implements IBuildEditor {
    private Properties buildConfig;
    private File buildFile;
    private String buildKey = "bin.includes";

    public BuildEditor(IProject project) {
        super(project);
    }

    public BuildEditor(IProject project, String buildKey) {
        super(project);
        if (buildKey != null) {
            this.buildKey = buildKey;
        }
    }

    @Override
    public void init() {
        this.buildConfig = new Properties();
        this.buildFile = this.getBuildProperties();
        if (this.buildFile != null && this.buildFile.exists()) {
            try {
                this.buildConfig.load(new FileInputStream(this.buildFile));
            }
            catch (FileNotFoundException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private File getBuildProperties() {
        this.buildFile = FileUtil.getWorkspaceFile((String)("/" + this.getProject().getName() + "/" + "build.properties"));
        return this.buildFile;
    }

    @Override
    public void addToBuild(String path) {
        if (this.exists()) {
            String currentValue = this.buildConfig.getProperty(this.buildKey);
            if (Arrays.asList(this.getElementsInBuild()).contains(path)) {
                return;
            }
            if (currentValue == null || currentValue.trim().equals("")) {
                this.buildConfig.setProperty(this.buildKey, path);
            } else {
                this.buildConfig.setProperty(this.buildKey, String.valueOf(currentValue) + "," + path);
            }
        }
    }

    @Override
    public void removeFromBuild(String path) {
        if (this.isRegisteredSourceFolder(path)) {
            List<String> allFiles = Arrays.asList(this.getElementsInBuild());
            this.buildConfig.setProperty(this.buildKey, "");
            for (String filePath : allFiles) {
                if (filePath.equals(path)) continue;
                this.addToBuild(filePath);
            }
        }
    }

    @Override
    public void save() {
        if (this.exists()) {
            try {
                this.buildConfig.store(new FileOutputStream(this.buildFile), "");
            }
            catch (FileNotFoundException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public void registerSourceFolder(String path) {
        if (this.exists() && !this.isRegisteredSourceFolder(path)) {
            String currentValue = this.buildConfig.getProperty("source..");
            if (currentValue == null || currentValue.trim().equals("")) {
                this.buildConfig.setProperty("source..", path);
            } else {
                this.buildConfig.setProperty("source..", String.valueOf(currentValue) + "," + path);
            }
        }
    }

    @Override
    public boolean isRegisteredSourceFolder(String path) {
        return Arrays.asList(this.getSourceFolders()).contains(path);
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        if (!this.getBuildProperties().exists()) {
            files.add("build.properties");
        }
        return files;
    }

    @Override
    public String[] getSourceFolders() {
        if (this.exists()) {
            String currentValue = this.buildConfig.getProperty("source..", "").replaceAll("\t|\r|\n", "").trim();
            String[] values = currentValue.split(",");
            return values;
        }
        return new String[0];
    }

    @Override
    public boolean exists() {
        return this.buildFile.getParentFile().exists() && this.buildFile.exists() && super.exists();
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains("build.properties") && !this.buildFile.exists()) {
            if (!this.buildFile.getParentFile().exists()) {
                this.buildFile.getParentFile().mkdirs();
            }
            try {
                this.buildFile.createNewFile();
                this.init();
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public String[] getElementsInBuild() {
        String value = this.buildConfig.getProperty(this.buildKey);
        return this.splitValues(value);
    }

    private String[] splitValues(String value) {
        if (value == null) {
            return new String[0];
        }
        return value.replace("\t|\r|\n", "").split(",");
    }

    @Override
    public void registerBinFolder(String binFolder) {
        if (this.isRegisteredBinFolder(binFolder)) {
            return;
        }
        String value = this.buildConfig.getProperty("bin..", "");
        value = value.trim().equals("") ? binFolder : String.valueOf(value) + "," + binFolder;
        this.buildConfig.setProperty("bin..", value);
    }

    @Override
    public boolean isRegisteredBinFolder(String binFolder) {
        List<String> folders = Arrays.asList(this.splitValues(this.buildConfig.getProperty("bin..", "")));
        return folders.contains(binFolder);
    }
}

