/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IClasspathEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathEditor
extends AbstractFileEditor
implements IClasspathEditor {
    private final IJavaProject javaProject;

    public ClasspathEditor(IProject project) throws AssertionFailedException {
        super(project);
        this.javaProject = JavaCore.create((IProject)project);
    }

    public ClasspathEditor(IJavaProject javaProject) {
        super(javaProject.getProject());
        this.javaProject = javaProject;
    }

    @Override
    public void init() {
    }

    @Override
    public void save() {
        try {
            this.javaProject.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (JavaModelException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void addSourceFolderToClasspath(String folderPath) {
        if (this.exists() && !this.isSourceFolderRegistered(folderPath)) {
            boolean isExported = false;
            IPath[] exclusionPatterns = new IPath[]{};
            IPath sourceAttachmentPath = null;
            IPath specificOutputLocation = null;
            boolean combineAccessRules = false;
            IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{};
            IPath sourceAttachmentRootPath = null;
            IAccessRule[] accessRules = null;
            int contentKind = 1;
            IPath[] inclusionPatterns = new IPath[]{};
            int entryKind = 3;
            Path path2 = new Path(folderPath);
            IClasspathEntry[] classpathes = null;
            try {
                classpathes = this.javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            IClasspathEntry[] entries = new IClasspathEntry[classpathes.length + 1];
            int i = 0;
            while (i < classpathes.length) {
                entries[i] = classpathes[i];
                ++i;
            }
            entries[classpathes.length] = new ClasspathEntry(contentKind, entryKind, (IPath)path2, inclusionPatterns, exclusionPatterns, sourceAttachmentPath, sourceAttachmentRootPath, specificOutputLocation, isExported, accessRules, combineAccessRules, extraAttributes);
            try {
                this.javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean isSourceFolderRegistered(String folderPath) {
        IClasspathEntry[] entries = null;
        try {
            entries = this.javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)new Path(folderPath))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean exists() {
        IFile classpath = this.getProject().getFile(".classpath");
        return classpath.exists();
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        IFile classpath = this.getProject().getFile(".classpath");
        if (!classpath.exists()) {
            files.add(".classpath");
        }
        return files;
    }

    @Override
    public void createFiles(Set<String> files) {
        IFile classpath;
        if (files.contains(".classpath") && !(classpath = this.getProject().getFile(".classpath")).exists()) {
            InputStream is = this.getInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<classpath>\n</classpath>\n");
            try {
                classpath.create(is, true, null);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public String[] getSourceFolders() {
        LinkedList<String> sourceFolders = new LinkedList<String>();
        IClasspathEntry[] entries = null;
        try {
            entries = this.javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                sourceFolders.add(entry.getPath().makeRelativeTo(this.javaProject.getPath()).toString());
            }
            ++i;
        }
        return sourceFolders.toArray(new String[sourceFolders.size()]);
    }

    @Override
    public String[] getBinFolders() {
        LinkedList<String> binFolders = new LinkedList<String>();
        try {
            binFolders.add(this.javaProject.getOutputLocation().makeRelativeTo(this.javaProject.getPath()).toString());
        }
        catch (JavaModelException ex) {
            Activator.log.error((Throwable)ex);
        }
        IClasspathEntry[] entries = null;
        try {
            entries = this.javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                binFolders.add(entry.getOutputLocation().makeRelativeTo(this.javaProject.getPath()).toString());
            }
            ++i;
        }
        return binFolders.toArray(new String[binFolders.size()]);
    }
}

