/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.util;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkTabsRegistrationUtil {
    public static final String HYPERLINK_TAB_REGISTRATION_ID = "org.eclipse.papyrus.infra.hyperlink.tab.registration";
    public static final String TAB = "tab";
    public static final String POSITION = "position";
    public static final String TAB_ID = "tabId";
    private static final String GENERIC_TAB_ID = "org.eclipse.papyrus.infra.hyperlink.helpers";
    public static final HyperLinkTabsRegistrationUtil INSTANCE = new HyperLinkTabsRegistrationUtil();

    private HyperLinkTabsRegistrationUtil() {
    }

    public Collection<AbstractHyperLinkTab> getAllHyperLinkTab() {
        IConfigurationElement[] config;
        TreeMap<Integer, AbstractHyperLinkTab> allTabs = new TreeMap<Integer, AbstractHyperLinkTab>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(HYPERLINK_TAB_REGISTRATION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            AbstractHyperLinkTab tab = null;
            try {
                Object h = e.createExecutableExtension(TAB);
                if (h instanceof AbstractHyperLinkTab) {
                    tab = (AbstractHyperLinkTab)h;
                    String o = e.getAttribute(POSITION);
                    Integer position = Integer.valueOf(o);
                    String tabId = e.getAttribute(TAB_ID);
                    tab.setTabId(tabId);
                    allTabs.put(position, tab);
                } else {
                    Activator.log.info(NLS.bind((String)Messages.HyperLinkTabRegistrationUtil_NotAnInstanceOf, (Object[])new Object[]{h, AbstractHyperLinkTab.class}));
                }
            }
            catch (NumberFormatException ex) {
                Activator.log.error(NLS.bind((String)Messages.HyperLinkTabRegistrationUtil_tabWillBeIgnored, tab), (Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error(Messages.HyperLinkTabRegistrationUtil_ICantCreateTheTab, (Throwable)ex);
            }
            ++n2;
        }
        Map<Integer, AbstractHyperLinkHelper> helpers = HyperLinkHelpersRegistrationUtil.INSTANCE.getHelperWithPosition();
        if (!helpers.isEmpty()) {
            allTabs.put(helpers.keySet().iterator().next(), new HyperLinkTab(GENERIC_TAB_ID, helpers.values()));
        }
        return allTabs.values();
    }
}

